<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Read the transcription data
$transcriptionPath = __DIR__ . '/transcription.json';
$transcriptionData = json_decode(file_get_contents($transcriptionPath), true);

$captions = [];

foreach ($transcriptionData['segments'] as $segment) {
    if (!isset($segment['words'])) {
        continue;
    }

    $words = $segment['words'];
    $currentChunk = [];
    $startTime = null;
    $endTime = null;
    $wordCount = 0;

    foreach ($words as $wordInfo) {
        if ($currentChunk === []) {
            $startTime = $wordInfo['start'];
        }

        $currentChunk[] = $wordInfo['word'];
        $endTime = $wordInfo['end'];
        $wordCount++;

        // Split into chunks of 1-3 words
        if ($wordCount >= rand(1, 3)) {
            $captions[] = [
                'text' => implode(' ', $currentChunk),
                'startTime' => $startTime,
                'endTime' => $endTime
            ];
            $currentChunk = [];
            $startTime = null;
            $endTime = null;
            $wordCount = 0;
        }
    }

    // Add any remaining words as a caption
    if ($currentChunk !== []) {
        $captions[] = [
            'text' => implode(' ', $currentChunk),
            'startTime' => $startTime,
            'endTime' => $endTime
        ];
    }
}

// Save the captions to a JSON file
$captionsPath = __DIR__ . '/captions.json';
file_put_contents($captionsPath, json_encode($captions, JSON_PRETTY_PRINT));
echo "Captions prepared and saved to captions.json\n";
?>
