/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * THIS FILE IS AUTOGENERATED by cddlconv 0.1.5.
 * Run `node tools/generate-bidi-types.mjs` to regenerate.
 * @see https://github.com/w3c/webdriver-bidi/blob/master/index.bs
 */
import z from 'zod';
export declare const EventSchema: z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
    type: z.ZodLiteral<"event">;
}, "strip", z.ZodTypeAny, {
    type: "event";
}, {
    type: "event";
}>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.contextCreated">;
    params: z.ZodLazy<any>;
}, "strip", z.ZodTypeAny, {
    method: "browsingContext.contextCreated";
    params?: any;
}, {
    method: "browsingContext.contextCreated";
    params?: any;
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.contextDestroyed">;
    params: any;
}, "strip", z.ZodTypeAny, {
    method: "browsingContext.contextDestroyed";
    params?: any;
}, {
    method: "browsingContext.contextDestroyed";
    params?: any;
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.domContentLoaded">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.domContentLoaded";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.domContentLoaded";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.downloadWillBegin">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.downloadWillBegin";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.downloadWillBegin";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.fragmentNavigated">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.fragmentNavigated";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.fragmentNavigated";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.load">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.load";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.load";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigationAborted">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationAborted";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationAborted";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigationFailed">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationFailed";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationFailed";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigationStarted">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationStarted";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationStarted";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.userPromptClosed">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        accepted: z.ZodBoolean;
        type: z.ZodLazy<z.ZodEnum<["alert", "beforeunload", "confirm", "prompt"]>>;
        userText: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    }, {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    };
    method: "browsingContext.userPromptClosed";
}, {
    params: {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    };
    method: "browsingContext.userPromptClosed";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.userPromptOpened">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        handler: z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>;
        message: z.ZodString;
        type: z.ZodLazy<z.ZodEnum<["alert", "beforeunload", "confirm", "prompt"]>>;
        defaultValue: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    }, {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    };
    method: "browsingContext.userPromptOpened";
}, {
    params: {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    };
    method: "browsingContext.userPromptOpened";
}>>]>>, z.ZodLazy<z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"log.entryAdded">;
    params: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        level: z.ZodLazy<z.ZodEnum<["debug", "info", "warn", "error"]>>;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
        text: z.ZodUnion<[z.ZodString, z.ZodNull]>;
        timestamp: z.ZodNumber;
        stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                columnNumber: z.ZodNumber;
                functionName: z.ZodString;
                lineNumber: z.ZodNumber;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }>>, "many">;
        }, "strip", z.ZodTypeAny, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }>>>;
    }, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }>>, z.ZodObject<{
        type: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        type: string;
    }, {
        type: string;
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        level: z.ZodLazy<z.ZodEnum<["debug", "info", "warn", "error"]>>;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
        text: z.ZodUnion<[z.ZodString, z.ZodNull]>;
        timestamp: z.ZodNumber;
        stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                columnNumber: z.ZodNumber;
                functionName: z.ZodString;
                lineNumber: z.ZodNumber;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }>>, "many">;
        }, "strip", z.ZodTypeAny, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }>>>;
    }, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"console">;
        method: z.ZodString;
        args: z.ZodArray<z.ZodLazy<any>, "many">;
    }, "strip", z.ZodTypeAny, {
        type: "console";
        args: any[];
        method: string;
    }, {
        type: "console";
        args: any[];
        method: string;
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        level: z.ZodLazy<z.ZodEnum<["debug", "info", "warn", "error"]>>;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
        text: z.ZodUnion<[z.ZodString, z.ZodNull]>;
        timestamp: z.ZodNumber;
        stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                columnNumber: z.ZodNumber;
                functionName: z.ZodString;
                lineNumber: z.ZodNumber;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }>>, "many">;
        }, "strip", z.ZodTypeAny, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }>>>;
    }, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"javascript">;
    }, "strip", z.ZodTypeAny, {
        type: "javascript";
    }, {
        type: "javascript";
    }>>>]>>;
}, "strip", z.ZodTypeAny, {
    params: ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "console";
        args: any[];
        method: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "javascript";
    });
    method: "log.entryAdded";
}, {
    params: ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "console";
        args: any[];
        method: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "javascript";
    });
    method: "log.entryAdded";
}>>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.authRequired">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        response: z.ZodLazy<z.ZodObject<{
            url: z.ZodString;
            protocol: z.ZodString;
            status: z.ZodNumber;
            statusText: z.ZodString;
            fromCache: z.ZodBoolean;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            mimeType: z.ZodString;
            bytesReceived: z.ZodNumber;
            headersSize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            content: z.ZodLazy<z.ZodObject<{
                size: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                size: number;
            }, {
                size: number;
            }>>;
            authChallenges: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                scheme: z.ZodString;
                realm: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                realm: string;
                scheme: string;
            }, {
                realm: string;
                scheme: string;
            }>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.authRequired";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.authRequired";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.beforeRequestSent">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        initiator: z.ZodLazy<z.ZodObject<{
            type: z.ZodEnum<["parser", "script", "preflight", "other"]>;
            columnNumber: z.ZodOptional<z.ZodNumber>;
            lineNumber: z.ZodOptional<z.ZodNumber>;
            stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                    columnNumber: z.ZodNumber;
                    functionName: z.ZodString;
                    lineNumber: z.ZodNumber;
                    url: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }, {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }>>, "many">;
            }, "strip", z.ZodTypeAny, {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            }, {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            }>>>;
            request: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        }, {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    }, {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    };
    method: "network.beforeRequestSent";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    };
    method: "network.beforeRequestSent";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.fetchError">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        errorText: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        errorText: string;
    }, {
        errorText: string;
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        errorText: string;
    };
    method: "network.fetchError";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        errorText: string;
    };
    method: "network.fetchError";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.responseCompleted">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        response: z.ZodLazy<z.ZodObject<{
            url: z.ZodString;
            protocol: z.ZodString;
            status: z.ZodNumber;
            statusText: z.ZodString;
            fromCache: z.ZodBoolean;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            mimeType: z.ZodString;
            bytesReceived: z.ZodNumber;
            headersSize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            content: z.ZodLazy<z.ZodObject<{
                size: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                size: number;
            }, {
                size: number;
            }>>;
            authChallenges: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                scheme: z.ZodString;
                realm: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                realm: string;
                scheme: string;
            }, {
                realm: string;
                scheme: string;
            }>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseCompleted";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseCompleted";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.responseStarted">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        response: z.ZodLazy<z.ZodObject<{
            url: z.ZodString;
            protocol: z.ZodString;
            status: z.ZodNumber;
            statusText: z.ZodString;
            fromCache: z.ZodBoolean;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            mimeType: z.ZodString;
            bytesReceived: z.ZodNumber;
            headersSize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            content: z.ZodLazy<z.ZodObject<{
                size: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                size: number;
            }, {
                size: number;
            }>>;
            authChallenges: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                scheme: z.ZodString;
                realm: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                realm: string;
                scheme: string;
            }, {
                realm: string;
                scheme: string;
            }>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseStarted";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseStarted";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.message">;
    params: z.ZodLazy<z.ZodObject<{
        channel: z.ZodLazy<z.ZodString>;
        data: any;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    }, {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    };
    method: "script.message";
}, {
    params: {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    };
    method: "script.message";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.realmCreated">;
    params: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"window">;
        context: z.ZodLazy<z.ZodString>;
        sandbox: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }, {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"dedicated-worker">;
        owners: z.ZodTuple<[z.ZodLazy<z.ZodString>], null>;
    }, "strip", z.ZodTypeAny, {
        type: "dedicated-worker";
        owners: [string];
    }, {
        type: "dedicated-worker";
        owners: [string];
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"shared-worker">;
    }, "strip", z.ZodTypeAny, {
        type: "shared-worker";
    }, {
        type: "shared-worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"service-worker">;
    }, "strip", z.ZodTypeAny, {
        type: "service-worker";
    }, {
        type: "service-worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"worker">;
    }, "strip", z.ZodTypeAny, {
        type: "worker";
    }, {
        type: "worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"paint-worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "paint-worklet";
    }, {
        type: "paint-worklet";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"audio-worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "audio-worklet";
    }, {
        type: "audio-worklet";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "worklet";
    }, {
        type: "worklet";
    }>>>]>>;
}, "strip", z.ZodTypeAny, {
    params: ({
        origin: string;
        realm: string;
    } & {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "dedicated-worker";
        owners: [string];
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "shared-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "service-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "paint-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "audio-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worklet";
    });
    method: "script.realmCreated";
}, {
    params: ({
        origin: string;
        realm: string;
    } & {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "dedicated-worker";
        owners: [string];
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "shared-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "service-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "paint-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "audio-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worklet";
    });
    method: "script.realmCreated";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.realmDestroyed">;
    params: z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        realm: string;
    }, {
        realm: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        realm: string;
    };
    method: "script.realmDestroyed";
}, {
    params: {
        realm: string;
    };
    method: "script.realmDestroyed";
}>>]>>]>>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
export declare const CommandSchema: z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
    id: z.ZodNumber;
}, "strip", z.ZodTypeAny, {
    id: number;
}, {
    id: number;
}>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browser.close">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "browser.close";
}, {
    params: Record<string, any>;
    method: "browser.close";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browser.createUserContext">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "browser.createUserContext";
}, {
    params: Record<string, any>;
    method: "browser.createUserContext";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browser.getUserContexts">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "browser.getUserContexts";
}, {
    params: Record<string, any>;
    method: "browser.getUserContexts";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browser.removeUserContext">;
    params: z.ZodLazy<z.ZodObject<{
        userContext: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        userContext: string;
    }, {
        userContext: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        userContext: string;
    };
    method: "browser.removeUserContext";
}, {
    params: {
        userContext: string;
    };
    method: "browser.removeUserContext";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.activate">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        context: string;
    }, {
        context: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
    };
    method: "browsingContext.activate";
}, {
    params: {
        context: string;
    };
    method: "browsingContext.activate";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.captureScreenshot">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        origin: z.ZodOptional<z.ZodDefault<z.ZodEnum<["viewport", "document"]>>>;
        format: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            type: z.ZodString;
            quality: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: string;
            quality?: number | undefined;
        }, {
            type: string;
            quality?: number | undefined;
        }>>>;
        clip: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"box">;
            x: z.ZodNumber;
            y: z.ZodNumber;
            width: z.ZodNumber;
            height: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        }, {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"element">;
            element: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                sharedId: z.ZodLazy<z.ZodString>;
                handle: z.ZodOptional<z.ZodLazy<z.ZodString>>;
            }, "strip", z.ZodTypeAny, {
                sharedId: string;
                handle?: string | undefined;
            }, {
                sharedId: string;
                handle?: string | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
        }, "strip", z.ZodTypeAny, {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        }, {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        }>>]>>>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        origin?: "viewport" | "document" | undefined;
        format?: {
            type: string;
            quality?: number | undefined;
        } | undefined;
        clip?: {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        } | {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        } | undefined;
    }, {
        context: string;
        origin?: "viewport" | "document" | undefined;
        format?: {
            type: string;
            quality?: number | undefined;
        } | undefined;
        clip?: {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        } | {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        } | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        origin?: "viewport" | "document" | undefined;
        format?: {
            type: string;
            quality?: number | undefined;
        } | undefined;
        clip?: {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        } | {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        } | undefined;
    };
    method: "browsingContext.captureScreenshot";
}, {
    params: {
        context: string;
        origin?: "viewport" | "document" | undefined;
        format?: {
            type: string;
            quality?: number | undefined;
        } | undefined;
        clip?: {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        } | {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        } | undefined;
    };
    method: "browsingContext.captureScreenshot";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.close">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        promptUnload: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        promptUnload?: boolean | undefined;
    }, {
        context: string;
        promptUnload?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        promptUnload?: boolean | undefined;
    };
    method: "browsingContext.close";
}, {
    params: {
        context: string;
        promptUnload?: boolean | undefined;
    };
    method: "browsingContext.close";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.create">;
    params: z.ZodLazy<z.ZodObject<{
        type: z.ZodLazy<z.ZodEnum<["tab", "window"]>>;
        referenceContext: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        background: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
        userContext: z.ZodOptional<z.ZodLazy<z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        type: "window" | "tab";
        background?: boolean | undefined;
        userContext?: string | undefined;
        referenceContext?: string | undefined;
    }, {
        type: "window" | "tab";
        background?: boolean | undefined;
        userContext?: string | undefined;
        referenceContext?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        type: "window" | "tab";
        background?: boolean | undefined;
        userContext?: string | undefined;
        referenceContext?: string | undefined;
    };
    method: "browsingContext.create";
}, {
    params: {
        type: "window" | "tab";
        background?: boolean | undefined;
        userContext?: string | undefined;
        referenceContext?: string | undefined;
    };
    method: "browsingContext.create";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.getTree">;
    params: z.ZodLazy<z.ZodObject<{
        maxDepth: z.ZodOptional<z.ZodNumber>;
        root: z.ZodOptional<z.ZodLazy<z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        root?: string | undefined;
        maxDepth?: number | undefined;
    }, {
        root?: string | undefined;
        maxDepth?: number | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        root?: string | undefined;
        maxDepth?: number | undefined;
    };
    method: "browsingContext.getTree";
}, {
    params: {
        root?: string | undefined;
        maxDepth?: number | undefined;
    };
    method: "browsingContext.getTree";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.handleUserPrompt">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        accept: z.ZodOptional<z.ZodBoolean>;
        userText: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        accept?: boolean | undefined;
        userText?: string | undefined;
    }, {
        context: string;
        accept?: boolean | undefined;
        userText?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        accept?: boolean | undefined;
        userText?: string | undefined;
    };
    method: "browsingContext.handleUserPrompt";
}, {
    params: {
        context: string;
        accept?: boolean | undefined;
        userText?: string | undefined;
    };
    method: "browsingContext.handleUserPrompt";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.locateNodes">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        locator: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"accessibility">;
            value: z.ZodObject<{
                name: z.ZodOptional<z.ZodString>;
                role: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                role?: string | undefined;
                name?: string | undefined;
            }, {
                role?: string | undefined;
                name?: string | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        }, {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"css">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "css";
            value: string;
        }, {
            type: "css";
            value: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"innerText">;
            value: z.ZodString;
            ignoreCase: z.ZodOptional<z.ZodBoolean>;
            matchType: z.ZodOptional<z.ZodEnum<["full", "partial"]>>;
            maxDepth: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        }, {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"xpath">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "xpath";
            value: string;
        }, {
            type: "xpath";
            value: string;
        }>>]>>;
        maxNodeCount: z.ZodOptional<z.ZodNumber>;
        serializationOptions: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            maxDomDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            maxObjectDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            includeShadowTree: z.ZodOptional<z.ZodDefault<z.ZodEnum<["none", "open", "all"]>>>;
        }, "strip", z.ZodTypeAny, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }>>>;
        startNodes: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            sharedId: z.ZodLazy<z.ZodString>;
            handle: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            sharedId: string;
            handle?: string | undefined;
        }, {
            sharedId: string;
            handle?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        locator: {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        } | {
            type: "css";
            value: string;
        } | {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        } | {
            type: "xpath";
            value: string;
        };
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        maxNodeCount?: number | undefined;
        startNodes?: ({
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>)[] | undefined;
    }, {
        context: string;
        locator: {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        } | {
            type: "css";
            value: string;
        } | {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        } | {
            type: "xpath";
            value: string;
        };
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        maxNodeCount?: number | undefined;
        startNodes?: ({
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>)[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        locator: {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        } | {
            type: "css";
            value: string;
        } | {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        } | {
            type: "xpath";
            value: string;
        };
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        maxNodeCount?: number | undefined;
        startNodes?: ({
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>)[] | undefined;
    };
    method: "browsingContext.locateNodes";
}, {
    params: {
        context: string;
        locator: {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        } | {
            type: "css";
            value: string;
        } | {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        } | {
            type: "xpath";
            value: string;
        };
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        maxNodeCount?: number | undefined;
        startNodes?: ({
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>)[] | undefined;
    };
    method: "browsingContext.locateNodes";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigate">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        url: z.ZodString;
        wait: z.ZodOptional<z.ZodLazy<z.ZodEnum<["none", "interactive", "complete"]>>>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
    }, {
        url: string;
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
    };
    method: "browsingContext.navigate";
}, {
    params: {
        url: string;
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
    };
    method: "browsingContext.navigate";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.print">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        background: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
        margin: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            bottom: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            left: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            right: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            top: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
        }, "strip", z.ZodTypeAny, {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        }, {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        }>>>;
        orientation: z.ZodOptional<z.ZodDefault<z.ZodEnum<["portrait", "landscape"]>>>;
        page: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            height: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            width: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
        }, "strip", z.ZodTypeAny, {
            width?: number | undefined;
            height?: number | undefined;
        }, {
            width?: number | undefined;
            height?: number | undefined;
        }>>>;
        pageRanges: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodNumber, z.ZodString]>, "many">>;
        scale: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
        shrinkToFit: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        orientation?: "portrait" | "landscape" | undefined;
        background?: boolean | undefined;
        margin?: {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        } | undefined;
        page?: {
            width?: number | undefined;
            height?: number | undefined;
        } | undefined;
        pageRanges?: (string | number)[] | undefined;
        scale?: number | undefined;
        shrinkToFit?: boolean | undefined;
    }, {
        context: string;
        orientation?: "portrait" | "landscape" | undefined;
        background?: boolean | undefined;
        margin?: {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        } | undefined;
        page?: {
            width?: number | undefined;
            height?: number | undefined;
        } | undefined;
        pageRanges?: (string | number)[] | undefined;
        scale?: number | undefined;
        shrinkToFit?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        orientation?: "portrait" | "landscape" | undefined;
        background?: boolean | undefined;
        margin?: {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        } | undefined;
        page?: {
            width?: number | undefined;
            height?: number | undefined;
        } | undefined;
        pageRanges?: (string | number)[] | undefined;
        scale?: number | undefined;
        shrinkToFit?: boolean | undefined;
    };
    method: "browsingContext.print";
}, {
    params: {
        context: string;
        orientation?: "portrait" | "landscape" | undefined;
        background?: boolean | undefined;
        margin?: {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        } | undefined;
        page?: {
            width?: number | undefined;
            height?: number | undefined;
        } | undefined;
        pageRanges?: (string | number)[] | undefined;
        scale?: number | undefined;
        shrinkToFit?: boolean | undefined;
    };
    method: "browsingContext.print";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.reload">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        ignoreCache: z.ZodOptional<z.ZodBoolean>;
        wait: z.ZodOptional<z.ZodLazy<z.ZodEnum<["none", "interactive", "complete"]>>>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
        ignoreCache?: boolean | undefined;
    }, {
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
        ignoreCache?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
        ignoreCache?: boolean | undefined;
    };
    method: "browsingContext.reload";
}, {
    params: {
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
        ignoreCache?: boolean | undefined;
    };
    method: "browsingContext.reload";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.setViewport">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        viewport: z.ZodOptional<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            width: z.ZodNumber;
            height: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            width: number;
            height: number;
        }, {
            width: number;
            height: number;
        }>>, z.ZodNull]>>;
        devicePixelRatio: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        viewport?: {
            width: number;
            height: number;
        } | null | undefined;
        devicePixelRatio?: number | null | undefined;
    }, {
        context: string;
        viewport?: {
            width: number;
            height: number;
        } | null | undefined;
        devicePixelRatio?: number | null | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        viewport?: {
            width: number;
            height: number;
        } | null | undefined;
        devicePixelRatio?: number | null | undefined;
    };
    method: "browsingContext.setViewport";
}, {
    params: {
        context: string;
        viewport?: {
            width: number;
            height: number;
        } | null | undefined;
        devicePixelRatio?: number | null | undefined;
    };
    method: "browsingContext.setViewport";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.traverseHistory">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        delta: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        context: string;
        delta: number;
    }, {
        context: string;
        delta: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        delta: number;
    };
    method: "browsingContext.traverseHistory";
}, {
    params: {
        context: string;
        delta: number;
    };
    method: "browsingContext.traverseHistory";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"input.performActions">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        actions: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"none">;
            id: z.ZodString;
            actions: z.ZodArray<z.ZodLazy<z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"pause">;
                duration: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                type: "pause";
                duration?: number | undefined;
            }, {
                type: "pause";
                duration?: number | undefined;
            }>>>, "many">;
        }, "strip", z.ZodTypeAny, {
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        }, {
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"key">;
            id: z.ZodString;
            actions: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"pause">;
                duration: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                type: "pause";
                duration?: number | undefined;
            }, {
                type: "pause";
                duration?: number | undefined;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"keyDown">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "keyDown";
                value: string;
            }, {
                type: "keyDown";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"keyUp">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "keyUp";
                value: string;
            }, {
                type: "keyUp";
                value: string;
            }>>]>>, "many">;
        }, "strip", z.ZodTypeAny, {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        }, {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"pointer">;
            id: z.ZodString;
            parameters: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                pointerType: z.ZodOptional<z.ZodDefault<z.ZodLazy<z.ZodEnum<["mouse", "pen", "touch"]>>>>;
            }, "strip", z.ZodTypeAny, {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            }, {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            }>>>;
            actions: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"pause">;
                duration: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                type: "pause";
                duration?: number | undefined;
            }, {
                type: "pause";
                duration?: number | undefined;
            }>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                type: z.ZodLiteral<"pointerDown">;
                button: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                type: "pointerDown";
                button: number;
            }, {
                type: "pointerDown";
                button: number;
            }>, z.ZodLazy<z.ZodObject<{
                width: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                height: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                pressure: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                tangentialPressure: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                twist: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                altitudeAngle: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                azimuthAngle: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            }, "strip", z.ZodTypeAny, {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }, {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }>>>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"pointerUp">;
                button: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                type: "pointerUp";
                button: number;
            }, {
                type: "pointerUp";
                button: number;
            }>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                type: z.ZodLiteral<"pointerMove">;
                x: z.ZodNumber;
                y: z.ZodNumber;
                duration: z.ZodOptional<z.ZodNumber>;
                origin: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLiteral<"viewport">, z.ZodLiteral<"pointer">, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"element">;
                    element: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        sharedId: z.ZodLazy<z.ZodString>;
                        handle: z.ZodOptional<z.ZodLazy<z.ZodString>>;
                    }, "strip", z.ZodTypeAny, {
                        sharedId: string;
                        handle?: string | undefined;
                    }, {
                        sharedId: string;
                        handle?: string | undefined;
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
                }, "strip", z.ZodTypeAny, {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                }, {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                }>>]>>>;
            }, "strip", z.ZodTypeAny, {
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            }, {
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            }>, z.ZodLazy<z.ZodObject<{
                width: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                height: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                pressure: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                tangentialPressure: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                twist: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                altitudeAngle: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                azimuthAngle: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            }, "strip", z.ZodTypeAny, {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }, {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }>>>>]>>, "many">;
        }, "strip", z.ZodTypeAny, {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        }, {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"wheel">;
            id: z.ZodString;
            actions: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"pause">;
                duration: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                type: "pause";
                duration?: number | undefined;
            }, {
                type: "pause";
                duration?: number | undefined;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"scroll">;
                x: z.ZodNumber;
                y: z.ZodNumber;
                deltaX: z.ZodNumber;
                deltaY: z.ZodNumber;
                duration: z.ZodOptional<z.ZodNumber>;
                origin: z.ZodOptional<z.ZodDefault<z.ZodLazy<z.ZodUnion<[z.ZodLiteral<"viewport">, z.ZodLiteral<"pointer">, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"element">;
                    element: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        sharedId: z.ZodLazy<z.ZodString>;
                        handle: z.ZodOptional<z.ZodLazy<z.ZodString>>;
                    }, "strip", z.ZodTypeAny, {
                        sharedId: string;
                        handle?: string | undefined;
                    }, {
                        sharedId: string;
                        handle?: string | undefined;
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
                }, "strip", z.ZodTypeAny, {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                }, {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                }>>]>>>>;
            }, "strip", z.ZodTypeAny, {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            }, {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            }>>]>>, "many">;
        }, "strip", z.ZodTypeAny, {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        }, {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        }>>]>>, "many">;
    }, "strip", z.ZodTypeAny, {
        context: string;
        actions: ({
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        } | {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        } | {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        } | {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        })[];
    }, {
        context: string;
        actions: ({
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        } | {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        } | {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        } | {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        })[];
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        actions: ({
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        } | {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        } | {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        } | {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        })[];
    };
    method: "input.performActions";
}, {
    params: {
        context: string;
        actions: ({
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        } | {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        } | {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        } | {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        })[];
    };
    method: "input.performActions";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"input.releaseActions">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        context: string;
    }, {
        context: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
    };
    method: "input.releaseActions";
}, {
    params: {
        context: string;
    };
    method: "input.releaseActions";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"input.setFiles">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        element: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            sharedId: z.ZodLazy<z.ZodString>;
            handle: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            sharedId: string;
            handle?: string | undefined;
        }, {
            sharedId: string;
            handle?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
        files: z.ZodArray<z.ZodString, "many">;
    }, "strip", z.ZodTypeAny, {
        element: {
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>;
        context: string;
        files: string[];
    }, {
        element: {
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>;
        context: string;
        files: string[];
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        element: {
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>;
        context: string;
        files: string[];
    };
    method: "input.setFiles";
}, {
    params: {
        element: {
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>;
        context: string;
        files: string[];
    };
    method: "input.setFiles";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.addIntercept">;
    params: z.ZodLazy<z.ZodObject<{
        phases: z.ZodArray<z.ZodLazy<z.ZodEnum<["beforeRequestSent", "responseStarted", "authRequired"]>>, "many">;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
        urlPatterns: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"pattern">;
            protocol: z.ZodOptional<z.ZodString>;
            hostname: z.ZodOptional<z.ZodString>;
            port: z.ZodOptional<z.ZodString>;
            pathname: z.ZodOptional<z.ZodString>;
            search: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        }, {
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            pattern: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            pattern: string;
        }, {
            type: "string";
            pattern: string;
        }>>]>>, "many">>;
    }, "strip", z.ZodTypeAny, {
        phases: ("beforeRequestSent" | "responseStarted" | "authRequired")[];
        contexts?: string[] | undefined;
        urlPatterns?: ({
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        } | {
            type: "string";
            pattern: string;
        })[] | undefined;
    }, {
        phases: ("beforeRequestSent" | "responseStarted" | "authRequired")[];
        contexts?: string[] | undefined;
        urlPatterns?: ({
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        } | {
            type: "string";
            pattern: string;
        })[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        phases: ("beforeRequestSent" | "responseStarted" | "authRequired")[];
        contexts?: string[] | undefined;
        urlPatterns?: ({
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        } | {
            type: "string";
            pattern: string;
        })[] | undefined;
    };
    method: "network.addIntercept";
}, {
    params: {
        phases: ("beforeRequestSent" | "responseStarted" | "authRequired")[];
        contexts?: string[] | undefined;
        urlPatterns?: ({
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        } | {
            type: "string";
            pattern: string;
        })[] | undefined;
    };
    method: "network.addIntercept";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.continueRequest">;
    params: z.ZodLazy<z.ZodObject<{
        request: z.ZodLazy<z.ZodString>;
        body: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
        }, {
            type: "string";
            value: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"base64">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "base64";
            value: string;
        }, {
            type: "base64";
            value: string;
        }>>]>>>;
        cookies: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }>>, "many">>;
        headers: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }>>, "many">>;
        method: z.ZodOptional<z.ZodString>;
        url: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        request: string;
        url?: string | undefined;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        method?: string | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
    }, {
        request: string;
        url?: string | undefined;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        method?: string | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        request: string;
        url?: string | undefined;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        method?: string | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
    };
    method: "network.continueRequest";
}, {
    params: {
        request: string;
        url?: string | undefined;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        method?: string | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
    };
    method: "network.continueRequest";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.continueResponse">;
    params: z.ZodLazy<z.ZodObject<{
        request: z.ZodLazy<z.ZodString>;
        cookies: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
            domain: z.ZodOptional<z.ZodString>;
            httpOnly: z.ZodOptional<z.ZodBoolean>;
            expiry: z.ZodOptional<z.ZodString>;
            maxAge: z.ZodOptional<z.ZodNumber>;
            path: z.ZodOptional<z.ZodString>;
            sameSite: z.ZodOptional<z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>>;
            secure: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }>>, "many">>;
        credentials: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"password">;
            username: z.ZodString;
            password: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "password";
            password: string;
            username: string;
        }, {
            type: "password";
            password: string;
            username: string;
        }>>>;
        headers: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }>>, "many">>;
        reasonPhrase: z.ZodOptional<z.ZodString>;
        statusCode: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        credentials?: {
            type: "password";
            password: string;
            username: string;
        } | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    }, {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        credentials?: {
            type: "password";
            password: string;
            username: string;
        } | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        credentials?: {
            type: "password";
            password: string;
            username: string;
        } | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    };
    method: "network.continueResponse";
}, {
    params: {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        credentials?: {
            type: "password";
            password: string;
            username: string;
        } | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    };
    method: "network.continueResponse";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.continueWithAuth">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        request: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        request: string;
    }, {
        request: string;
    }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        action: z.ZodLiteral<"provideCredentials">;
        credentials: z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"password">;
            username: z.ZodString;
            password: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "password";
            password: string;
            username: string;
        }, {
            type: "password";
            password: string;
            username: string;
        }>>;
    }, "strip", z.ZodTypeAny, {
        credentials: {
            type: "password";
            password: string;
            username: string;
        };
        action: "provideCredentials";
    }, {
        credentials: {
            type: "password";
            password: string;
            username: string;
        };
        action: "provideCredentials";
    }>>, z.ZodLazy<z.ZodObject<{
        action: z.ZodEnum<["default", "cancel"]>;
    }, "strip", z.ZodTypeAny, {
        action: "default" | "cancel";
    }, {
        action: "default" | "cancel";
    }>>]>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        request: string;
    } & ({
        credentials: {
            type: "password";
            password: string;
            username: string;
        };
        action: "provideCredentials";
    } | {
        action: "default" | "cancel";
    });
    method: "network.continueWithAuth";
}, {
    params: {
        request: string;
    } & ({
        credentials: {
            type: "password";
            password: string;
            username: string;
        };
        action: "provideCredentials";
    } | {
        action: "default" | "cancel";
    });
    method: "network.continueWithAuth";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.failRequest">;
    params: z.ZodLazy<z.ZodObject<{
        request: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        request: string;
    }, {
        request: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        request: string;
    };
    method: "network.failRequest";
}, {
    params: {
        request: string;
    };
    method: "network.failRequest";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.provideResponse">;
    params: z.ZodLazy<z.ZodObject<{
        request: z.ZodLazy<z.ZodString>;
        body: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
        }, {
            type: "string";
            value: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"base64">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "base64";
            value: string;
        }, {
            type: "base64";
            value: string;
        }>>]>>>;
        cookies: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
            domain: z.ZodOptional<z.ZodString>;
            httpOnly: z.ZodOptional<z.ZodBoolean>;
            expiry: z.ZodOptional<z.ZodString>;
            maxAge: z.ZodOptional<z.ZodNumber>;
            path: z.ZodOptional<z.ZodString>;
            sameSite: z.ZodOptional<z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>>;
            secure: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }>>, "many">>;
        headers: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }>>, "many">>;
        reasonPhrase: z.ZodOptional<z.ZodString>;
        statusCode: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    }, {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    };
    method: "network.provideResponse";
}, {
    params: {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    };
    method: "network.provideResponse";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.removeIntercept">;
    params: z.ZodLazy<z.ZodObject<{
        intercept: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        intercept: string;
    }, {
        intercept: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        intercept: string;
    };
    method: "network.removeIntercept";
}, {
    params: {
        intercept: string;
    };
    method: "network.removeIntercept";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.setCacheBehavior">;
    params: z.ZodLazy<z.ZodObject<{
        cacheBehavior: z.ZodEnum<["default", "bypass"]>;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        cacheBehavior: "default" | "bypass";
        contexts?: string[] | undefined;
    }, {
        cacheBehavior: "default" | "bypass";
        contexts?: string[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        cacheBehavior: "default" | "bypass";
        contexts?: string[] | undefined;
    };
    method: "network.setCacheBehavior";
}, {
    params: {
        cacheBehavior: "default" | "bypass";
        contexts?: string[] | undefined;
    };
    method: "network.setCacheBehavior";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.addPreloadScript">;
    params: z.ZodLazy<z.ZodObject<{
        functionDeclaration: z.ZodString;
        arguments: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"channel">;
            value: z.ZodLazy<z.ZodObject<{
                channel: z.ZodLazy<z.ZodString>;
                serializationOptions: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                    maxDomDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
                    maxObjectDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
                    includeShadowTree: z.ZodOptional<z.ZodDefault<z.ZodEnum<["none", "open", "all"]>>>;
                }, "strip", z.ZodTypeAny, {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                }, {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                }>>>;
                ownership: z.ZodOptional<z.ZodLazy<z.ZodEnum<["root", "none"]>>>;
            }, "strip", z.ZodTypeAny, {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            }, {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }, {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }>>, "many">>;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
        sandbox: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        functionDeclaration: string;
        contexts?: string[] | undefined;
        sandbox?: string | undefined;
        arguments?: {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }[] | undefined;
    }, {
        functionDeclaration: string;
        contexts?: string[] | undefined;
        sandbox?: string | undefined;
        arguments?: {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        functionDeclaration: string;
        contexts?: string[] | undefined;
        sandbox?: string | undefined;
        arguments?: {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }[] | undefined;
    };
    method: "script.addPreloadScript";
}, {
    params: {
        functionDeclaration: string;
        contexts?: string[] | undefined;
        sandbox?: string | undefined;
        arguments?: {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }[] | undefined;
    };
    method: "script.addPreloadScript";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.callFunction">;
    params: z.ZodLazy<z.ZodObject<{
        functionDeclaration: z.ZodString;
        awaitPromise: z.ZodBoolean;
        target: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            context: z.ZodLazy<z.ZodString>;
            sandbox: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            context: string;
            sandbox?: string | undefined;
        }, {
            context: string;
            sandbox?: string | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
        }, {
            realm: string;
        }>>]>>;
        arguments: z.ZodOptional<z.ZodArray<z.ZodLazy<any>, "many">>;
        resultOwnership: z.ZodOptional<z.ZodLazy<z.ZodEnum<["root", "none"]>>>;
        serializationOptions: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            maxDomDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            maxObjectDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            includeShadowTree: z.ZodOptional<z.ZodDefault<z.ZodEnum<["none", "open", "all"]>>>;
        }, "strip", z.ZodTypeAny, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }>>>;
        this: any;
        userActivation: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
    }, "strip", z.ZodTypeAny, {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        functionDeclaration: string;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
        arguments?: any[] | undefined;
        this?: any;
    }, {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        functionDeclaration: string;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
        arguments?: any[] | undefined;
        this?: any;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        functionDeclaration: string;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
        arguments?: any[] | undefined;
        this?: any;
    };
    method: "script.callFunction";
}, {
    params: {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        functionDeclaration: string;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
        arguments?: any[] | undefined;
        this?: any;
    };
    method: "script.callFunction";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.disown">;
    params: z.ZodLazy<z.ZodObject<{
        handles: z.ZodArray<z.ZodLazy<z.ZodString>, "many">;
        target: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            context: z.ZodLazy<z.ZodString>;
            sandbox: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            context: string;
            sandbox?: string | undefined;
        }, {
            context: string;
            sandbox?: string | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
        }, {
            realm: string;
        }>>]>>;
    }, "strip", z.ZodTypeAny, {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        handles: string[];
    }, {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        handles: string[];
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        handles: string[];
    };
    method: "script.disown";
}, {
    params: {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        handles: string[];
    };
    method: "script.disown";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.evaluate">;
    params: z.ZodLazy<z.ZodObject<{
        expression: z.ZodString;
        target: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            context: z.ZodLazy<z.ZodString>;
            sandbox: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            context: string;
            sandbox?: string | undefined;
        }, {
            context: string;
            sandbox?: string | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
        }, {
            realm: string;
        }>>]>>;
        awaitPromise: z.ZodBoolean;
        resultOwnership: z.ZodOptional<z.ZodLazy<z.ZodEnum<["root", "none"]>>>;
        serializationOptions: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            maxDomDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            maxObjectDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            includeShadowTree: z.ZodOptional<z.ZodDefault<z.ZodEnum<["none", "open", "all"]>>>;
        }, "strip", z.ZodTypeAny, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }>>>;
        userActivation: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
    }, "strip", z.ZodTypeAny, {
        expression: string;
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
    }, {
        expression: string;
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        expression: string;
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
    };
    method: "script.evaluate";
}, {
    params: {
        expression: string;
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
    };
    method: "script.evaluate";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.getRealms">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        type: z.ZodOptional<z.ZodLazy<z.ZodEnum<["window", "dedicated-worker", "shared-worker", "service-worker", "worker", "paint-worklet", "audio-worklet", "worklet"]>>>;
    }, "strip", z.ZodTypeAny, {
        type?: "worker" | "window" | "dedicated-worker" | "shared-worker" | "service-worker" | "paint-worklet" | "audio-worklet" | "worklet" | undefined;
        context?: string | undefined;
    }, {
        type?: "worker" | "window" | "dedicated-worker" | "shared-worker" | "service-worker" | "paint-worklet" | "audio-worklet" | "worklet" | undefined;
        context?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        type?: "worker" | "window" | "dedicated-worker" | "shared-worker" | "service-worker" | "paint-worklet" | "audio-worklet" | "worklet" | undefined;
        context?: string | undefined;
    };
    method: "script.getRealms";
}, {
    params: {
        type?: "worker" | "window" | "dedicated-worker" | "shared-worker" | "service-worker" | "paint-worklet" | "audio-worklet" | "worklet" | undefined;
        context?: string | undefined;
    };
    method: "script.getRealms";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.removePreloadScript">;
    params: z.ZodLazy<z.ZodObject<{
        script: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        script: string;
    }, {
        script: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        script: string;
    };
    method: "script.removePreloadScript";
}, {
    params: {
        script: string;
    };
    method: "script.removePreloadScript";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.end">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "session.end";
}, {
    params: Record<string, any>;
    method: "session.end";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.new">;
    params: z.ZodLazy<z.ZodObject<{
        capabilities: z.ZodLazy<z.ZodObject<{
            alwaysMatch: z.ZodOptional<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
                browserName: z.ZodOptional<z.ZodString>;
                browserVersion: z.ZodOptional<z.ZodString>;
                platformName: z.ZodOptional<z.ZodString>;
                proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"autodetect">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "autodetect";
                }, {
                    proxyType: "autodetect";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"direct">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "direct";
                }, {
                    proxyType: "direct";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"manual">;
                    ftpProxy: z.ZodOptional<z.ZodString>;
                    httpProxy: z.ZodOptional<z.ZodString>;
                    sslProxy: z.ZodOptional<z.ZodString>;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    socksProxy: z.ZodString;
                    socksVersion: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    socksProxy: string;
                    socksVersion: number;
                }, {
                    socksProxy: string;
                    socksVersion: number;
                }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                    noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                }, "strip", z.ZodTypeAny, {
                    noProxy?: string[] | undefined;
                }, {
                    noProxy?: string[] | undefined;
                }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"pac">;
                    proxyAutoconfigUrl: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"system">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "system";
                }, {
                    proxyType: "system";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
                unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                    alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                }, "strip", z.ZodTypeAny, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }>>>;
            }, "strip", z.ZodTypeAny, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>>;
            firstMatch: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
                browserName: z.ZodOptional<z.ZodString>;
                browserVersion: z.ZodOptional<z.ZodString>;
                platformName: z.ZodOptional<z.ZodString>;
                proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"autodetect">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "autodetect";
                }, {
                    proxyType: "autodetect";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"direct">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "direct";
                }, {
                    proxyType: "direct";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"manual">;
                    ftpProxy: z.ZodOptional<z.ZodString>;
                    httpProxy: z.ZodOptional<z.ZodString>;
                    sslProxy: z.ZodOptional<z.ZodString>;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    socksProxy: z.ZodString;
                    socksVersion: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    socksProxy: string;
                    socksVersion: number;
                }, {
                    socksProxy: string;
                    socksVersion: number;
                }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                    noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                }, "strip", z.ZodTypeAny, {
                    noProxy?: string[] | undefined;
                }, {
                    noProxy?: string[] | undefined;
                }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"pac">;
                    proxyAutoconfigUrl: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"system">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "system";
                }, {
                    proxyType: "system";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
                unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                    alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                }, "strip", z.ZodTypeAny, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }>>>;
            }, "strip", z.ZodTypeAny, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        }, {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    }, {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    };
    method: "session.new";
}, {
    params: {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    };
    method: "session.new";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.status">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "session.status";
}, {
    params: Record<string, any>;
    method: "session.status";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.subscribe">;
    params: z.ZodLazy<z.ZodObject<{
        events: z.ZodArray<z.ZodString, "many">;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        events: string[];
        contexts?: string[] | undefined;
    }, {
        events: string[];
        contexts?: string[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.subscribe";
}, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.subscribe";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.unsubscribe">;
    params: z.ZodLazy<z.ZodObject<{
        events: z.ZodArray<z.ZodString, "many">;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        events: string[];
        contexts?: string[] | undefined;
    }, {
        events: string[];
        contexts?: string[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.unsubscribe";
}, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.unsubscribe";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"storage.deleteCookies">;
    params: z.ZodLazy<z.ZodObject<{
        filter: z.ZodOptional<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            name: z.ZodOptional<z.ZodString>;
            value: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>>;
            domain: z.ZodOptional<z.ZodString>;
            path: z.ZodOptional<z.ZodString>;
            size: z.ZodOptional<z.ZodNumber>;
            httpOnly: z.ZodOptional<z.ZodBoolean>;
            secure: z.ZodOptional<z.ZodBoolean>;
            sameSite: z.ZodOptional<z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>>;
            expiry: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }, {
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>>;
        partition: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"context">;
            context: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "context";
            context: string;
        }, {
            type: "context";
            context: string;
        }>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            type: z.ZodLiteral<"storageKey">;
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>]>>>;
    }, "strip", z.ZodTypeAny, {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }, {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.deleteCookies";
}, {
    params: {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.deleteCookies";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"storage.getCookies">;
    params: z.ZodLazy<z.ZodObject<{
        filter: z.ZodOptional<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            name: z.ZodOptional<z.ZodString>;
            value: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>>;
            domain: z.ZodOptional<z.ZodString>;
            path: z.ZodOptional<z.ZodString>;
            size: z.ZodOptional<z.ZodNumber>;
            httpOnly: z.ZodOptional<z.ZodBoolean>;
            secure: z.ZodOptional<z.ZodBoolean>;
            sameSite: z.ZodOptional<z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>>;
            expiry: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }, {
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>>;
        partition: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"context">;
            context: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "context";
            context: string;
        }, {
            type: "context";
            context: string;
        }>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            type: z.ZodLiteral<"storageKey">;
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>]>>>;
    }, "strip", z.ZodTypeAny, {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }, {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.getCookies";
}, {
    params: {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.getCookies";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"storage.setCookie">;
    params: z.ZodLazy<z.ZodObject<{
        cookie: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
            domain: z.ZodString;
            path: z.ZodOptional<z.ZodString>;
            httpOnly: z.ZodOptional<z.ZodBoolean>;
            secure: z.ZodOptional<z.ZodBoolean>;
            sameSite: z.ZodOptional<z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>>;
            expiry: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
        partition: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"context">;
            context: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "context";
            context: string;
        }, {
            type: "context";
            context: string;
        }>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            type: z.ZodLiteral<"storageKey">;
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>]>>>;
    }, "strip", z.ZodTypeAny, {
        cookie: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }, {
        cookie: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        cookie: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.setCookie";
}, {
    params: {
        cookie: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.setCookie";
}>>]>>]>>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
export declare const CommandResponseSchema: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
    type: z.ZodLiteral<"success">;
    id: z.ZodNumber;
    result: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
    }, {
        data: string;
    }>>, z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        context: string;
    }, {
        context: string;
    }>>, z.ZodLazy<z.ZodObject<{
        contexts: any;
    }, "strip", z.ZodTypeAny, {
        contexts?: any;
    }, {
        contexts?: any;
    }>>, z.ZodLazy<z.ZodObject<{
        nodes: z.ZodArray<any, "many">;
    }, "strip", z.ZodTypeAny, {
        nodes: any[];
    }, {
        nodes: any[];
    }>>, z.ZodLazy<z.ZodObject<{
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
    }, {
        url: string;
        navigation: string | null;
    }>>, z.ZodLazy<z.ZodObject<{
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
    }, {
        data: string;
    }>>, z.ZodLazy<z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>>]>>, z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>, z.ZodLazy<z.ZodLazy<z.ZodObject<{
        intercept: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        intercept: string;
    }, {
        intercept: string;
    }>>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        script: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        script: string;
    }, {
        script: string;
    }>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        type: z.ZodLiteral<"success">;
        result: any;
        realm: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "success";
        realm: string;
        result?: any;
    }, {
        type: "success";
        realm: string;
        result?: any;
    }>>, z.ZodLazy<z.ZodObject<{
        type: z.ZodLiteral<"exception">;
        exceptionDetails: z.ZodLazy<z.ZodObject<{
            columnNumber: z.ZodNumber;
            exception: any;
            lineNumber: z.ZodNumber;
            stackTrace: z.ZodLazy<z.ZodObject<{
                callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                    columnNumber: z.ZodNumber;
                    functionName: z.ZodString;
                    lineNumber: z.ZodNumber;
                    url: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }, {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }>>, "many">;
            }, "strip", z.ZodTypeAny, {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            }, {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            }>>;
            text: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        }, {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        }>>;
        realm: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "exception";
        realm: string;
        exceptionDetails: {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        };
    }, {
        type: "exception";
        realm: string;
        exceptionDetails: {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        };
    }>>]>>, z.ZodLazy<z.ZodObject<{
        realms: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"window">;
            context: z.ZodLazy<z.ZodString>;
            sandbox: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }, {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"dedicated-worker">;
            owners: z.ZodTuple<[z.ZodLazy<z.ZodString>], null>;
        }, "strip", z.ZodTypeAny, {
            type: "dedicated-worker";
            owners: [string];
        }, {
            type: "dedicated-worker";
            owners: [string];
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"shared-worker">;
        }, "strip", z.ZodTypeAny, {
            type: "shared-worker";
        }, {
            type: "shared-worker";
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"service-worker">;
        }, "strip", z.ZodTypeAny, {
            type: "service-worker";
        }, {
            type: "service-worker";
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"worker">;
        }, "strip", z.ZodTypeAny, {
            type: "worker";
        }, {
            type: "worker";
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"paint-worklet">;
        }, "strip", z.ZodTypeAny, {
            type: "paint-worklet";
        }, {
            type: "paint-worklet";
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"audio-worklet">;
        }, "strip", z.ZodTypeAny, {
            type: "audio-worklet";
        }, {
            type: "audio-worklet";
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"worklet">;
        }, "strip", z.ZodTypeAny, {
            type: "worklet";
        }, {
            type: "worklet";
        }>>>]>>, "many">;
    }, "strip", z.ZodTypeAny, {
        realms: (({
            origin: string;
            realm: string;
        } & {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "dedicated-worker";
            owners: [string];
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "shared-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "service-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "paint-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "audio-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worklet";
        }))[];
    }, {
        realms: (({
            origin: string;
            realm: string;
        } & {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "dedicated-worker";
            owners: [string];
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "shared-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "service-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "paint-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "audio-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worklet";
        }))[];
    }>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        sessionId: z.ZodString;
        capabilities: z.ZodIntersection<z.ZodObject<{
            acceptInsecureCerts: z.ZodBoolean;
            browserName: z.ZodString;
            browserVersion: z.ZodString;
            platformName: z.ZodString;
            setWindowRect: z.ZodBoolean;
            userAgent: z.ZodString;
            proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"autodetect">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "autodetect";
            }, {
                proxyType: "autodetect";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"direct">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "direct";
            }, {
                proxyType: "direct";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"manual">;
                ftpProxy: z.ZodOptional<z.ZodString>;
                httpProxy: z.ZodOptional<z.ZodString>;
                sslProxy: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            }, {
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                socksProxy: z.ZodString;
                socksVersion: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                socksProxy: string;
                socksVersion: number;
            }, {
                socksProxy: string;
                socksVersion: number;
            }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                noProxy?: string[] | undefined;
            }, {
                noProxy?: string[] | undefined;
            }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"pac">;
                proxyAutoconfigUrl: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            }, {
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"system">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "system";
            }, {
                proxyType: "system";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
            unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            }, "strip", z.ZodTypeAny, {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            }, {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            }>>>;
            webSocketUrl: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        }, {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
    }, "strip", z.ZodTypeAny, {
        capabilities: {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        } & Record<string, any>;
        sessionId: string;
    }, {
        capabilities: {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        } & Record<string, any>;
        sessionId: string;
    }>>, z.ZodLazy<z.ZodObject<{
        ready: z.ZodBoolean;
        message: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        message: string;
        ready: boolean;
    }, {
        message: string;
        ready: boolean;
    }>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        partitionKey: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
    }, "strip", z.ZodTypeAny, {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }, {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }>>, z.ZodLazy<z.ZodObject<{
        cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
            domain: z.ZodString;
            path: z.ZodString;
            size: z.ZodNumber;
            httpOnly: z.ZodBoolean;
            secure: z.ZodBoolean;
            sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
            expiry: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        }, {
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
        partitionKey: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
    }, "strip", z.ZodTypeAny, {
        cookies: ({
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        } & Record<string, any>)[];
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }, {
        cookies: ({
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        } & Record<string, any>)[];
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }>>, z.ZodLazy<z.ZodObject<{
        partitionKey: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
    }, "strip", z.ZodTypeAny, {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }, {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }>>]>>]>>;
}, "strip", z.ZodTypeAny, {
    type: "success";
    id: number;
    result: Record<string, any> | {
        data: string;
    } | {
        context: string;
    } | {
        contexts?: any;
    } | {
        nodes: any[];
    } | {
        url: string;
        navigation: string | null;
    } | {
        data: string;
    } | {} | {
        intercept: string;
    } | {
        script: string;
    } | {
        type: "success";
        realm: string;
        result?: any;
    } | {
        type: "exception";
        realm: string;
        exceptionDetails: {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        };
    } | {
        realms: (({
            origin: string;
            realm: string;
        } & {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "dedicated-worker";
            owners: [string];
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "shared-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "service-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "paint-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "audio-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worklet";
        }))[];
    } | {
        capabilities: {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        } & Record<string, any>;
        sessionId: string;
    } | {
        message: string;
        ready: boolean;
    } | {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    } | {
        cookies: ({
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        } & Record<string, any>)[];
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    } | {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    };
}, {
    type: "success";
    id: number;
    result: Record<string, any> | {
        data: string;
    } | {
        context: string;
    } | {
        contexts?: any;
    } | {
        nodes: any[];
    } | {
        url: string;
        navigation: string | null;
    } | {
        data: string;
    } | {} | {
        intercept: string;
    } | {
        script: string;
    } | {
        type: "success";
        realm: string;
        result?: any;
    } | {
        type: "exception";
        realm: string;
        exceptionDetails: {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        };
    } | {
        realms: (({
            origin: string;
            realm: string;
        } & {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "dedicated-worker";
            owners: [string];
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "shared-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "service-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "paint-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "audio-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worklet";
        }))[];
    } | {
        capabilities: {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        } & Record<string, any>;
        sessionId: string;
    } | {
        message: string;
        ready: boolean;
    } | {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    } | {
        cookies: ({
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        } & Record<string, any>)[];
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    } | {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    };
}>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
export declare const EventDataSchema: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.contextCreated">;
    params: z.ZodLazy<any>;
}, "strip", z.ZodTypeAny, {
    method: "browsingContext.contextCreated";
    params?: any;
}, {
    method: "browsingContext.contextCreated";
    params?: any;
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.contextDestroyed">;
    params: any;
}, "strip", z.ZodTypeAny, {
    method: "browsingContext.contextDestroyed";
    params?: any;
}, {
    method: "browsingContext.contextDestroyed";
    params?: any;
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.domContentLoaded">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.domContentLoaded";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.domContentLoaded";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.downloadWillBegin">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.downloadWillBegin";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.downloadWillBegin";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.fragmentNavigated">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.fragmentNavigated";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.fragmentNavigated";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.load">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.load";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.load";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigationAborted">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationAborted";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationAborted";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigationFailed">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationFailed";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationFailed";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigationStarted">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationStarted";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationStarted";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.userPromptClosed">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        accepted: z.ZodBoolean;
        type: z.ZodLazy<z.ZodEnum<["alert", "beforeunload", "confirm", "prompt"]>>;
        userText: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    }, {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    };
    method: "browsingContext.userPromptClosed";
}, {
    params: {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    };
    method: "browsingContext.userPromptClosed";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.userPromptOpened">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        handler: z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>;
        message: z.ZodString;
        type: z.ZodLazy<z.ZodEnum<["alert", "beforeunload", "confirm", "prompt"]>>;
        defaultValue: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    }, {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    };
    method: "browsingContext.userPromptOpened";
}, {
    params: {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    };
    method: "browsingContext.userPromptOpened";
}>>]>>, z.ZodLazy<z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"log.entryAdded">;
    params: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        level: z.ZodLazy<z.ZodEnum<["debug", "info", "warn", "error"]>>;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
        text: z.ZodUnion<[z.ZodString, z.ZodNull]>;
        timestamp: z.ZodNumber;
        stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                columnNumber: z.ZodNumber;
                functionName: z.ZodString;
                lineNumber: z.ZodNumber;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }>>, "many">;
        }, "strip", z.ZodTypeAny, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }>>>;
    }, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }>>, z.ZodObject<{
        type: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        type: string;
    }, {
        type: string;
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        level: z.ZodLazy<z.ZodEnum<["debug", "info", "warn", "error"]>>;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
        text: z.ZodUnion<[z.ZodString, z.ZodNull]>;
        timestamp: z.ZodNumber;
        stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                columnNumber: z.ZodNumber;
                functionName: z.ZodString;
                lineNumber: z.ZodNumber;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }>>, "many">;
        }, "strip", z.ZodTypeAny, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }>>>;
    }, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"console">;
        method: z.ZodString;
        args: z.ZodArray<z.ZodLazy<any>, "many">;
    }, "strip", z.ZodTypeAny, {
        type: "console";
        args: any[];
        method: string;
    }, {
        type: "console";
        args: any[];
        method: string;
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        level: z.ZodLazy<z.ZodEnum<["debug", "info", "warn", "error"]>>;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
        text: z.ZodUnion<[z.ZodString, z.ZodNull]>;
        timestamp: z.ZodNumber;
        stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                columnNumber: z.ZodNumber;
                functionName: z.ZodString;
                lineNumber: z.ZodNumber;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }>>, "many">;
        }, "strip", z.ZodTypeAny, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }>>>;
    }, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"javascript">;
    }, "strip", z.ZodTypeAny, {
        type: "javascript";
    }, {
        type: "javascript";
    }>>>]>>;
}, "strip", z.ZodTypeAny, {
    params: ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "console";
        args: any[];
        method: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "javascript";
    });
    method: "log.entryAdded";
}, {
    params: ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "console";
        args: any[];
        method: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "javascript";
    });
    method: "log.entryAdded";
}>>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.authRequired">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        response: z.ZodLazy<z.ZodObject<{
            url: z.ZodString;
            protocol: z.ZodString;
            status: z.ZodNumber;
            statusText: z.ZodString;
            fromCache: z.ZodBoolean;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            mimeType: z.ZodString;
            bytesReceived: z.ZodNumber;
            headersSize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            content: z.ZodLazy<z.ZodObject<{
                size: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                size: number;
            }, {
                size: number;
            }>>;
            authChallenges: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                scheme: z.ZodString;
                realm: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                realm: string;
                scheme: string;
            }, {
                realm: string;
                scheme: string;
            }>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.authRequired";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.authRequired";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.beforeRequestSent">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        initiator: z.ZodLazy<z.ZodObject<{
            type: z.ZodEnum<["parser", "script", "preflight", "other"]>;
            columnNumber: z.ZodOptional<z.ZodNumber>;
            lineNumber: z.ZodOptional<z.ZodNumber>;
            stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                    columnNumber: z.ZodNumber;
                    functionName: z.ZodString;
                    lineNumber: z.ZodNumber;
                    url: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }, {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }>>, "many">;
            }, "strip", z.ZodTypeAny, {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            }, {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            }>>>;
            request: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        }, {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    }, {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    };
    method: "network.beforeRequestSent";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    };
    method: "network.beforeRequestSent";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.fetchError">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        errorText: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        errorText: string;
    }, {
        errorText: string;
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        errorText: string;
    };
    method: "network.fetchError";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        errorText: string;
    };
    method: "network.fetchError";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.responseCompleted">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        response: z.ZodLazy<z.ZodObject<{
            url: z.ZodString;
            protocol: z.ZodString;
            status: z.ZodNumber;
            statusText: z.ZodString;
            fromCache: z.ZodBoolean;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            mimeType: z.ZodString;
            bytesReceived: z.ZodNumber;
            headersSize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            content: z.ZodLazy<z.ZodObject<{
                size: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                size: number;
            }, {
                size: number;
            }>>;
            authChallenges: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                scheme: z.ZodString;
                realm: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                realm: string;
                scheme: string;
            }, {
                realm: string;
                scheme: string;
            }>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseCompleted";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseCompleted";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.responseStarted">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        response: z.ZodLazy<z.ZodObject<{
            url: z.ZodString;
            protocol: z.ZodString;
            status: z.ZodNumber;
            statusText: z.ZodString;
            fromCache: z.ZodBoolean;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            mimeType: z.ZodString;
            bytesReceived: z.ZodNumber;
            headersSize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            content: z.ZodLazy<z.ZodObject<{
                size: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                size: number;
            }, {
                size: number;
            }>>;
            authChallenges: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                scheme: z.ZodString;
                realm: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                realm: string;
                scheme: string;
            }, {
                realm: string;
                scheme: string;
            }>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseStarted";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseStarted";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.message">;
    params: z.ZodLazy<z.ZodObject<{
        channel: z.ZodLazy<z.ZodString>;
        data: any;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    }, {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    };
    method: "script.message";
}, {
    params: {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    };
    method: "script.message";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.realmCreated">;
    params: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"window">;
        context: z.ZodLazy<z.ZodString>;
        sandbox: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }, {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"dedicated-worker">;
        owners: z.ZodTuple<[z.ZodLazy<z.ZodString>], null>;
    }, "strip", z.ZodTypeAny, {
        type: "dedicated-worker";
        owners: [string];
    }, {
        type: "dedicated-worker";
        owners: [string];
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"shared-worker">;
    }, "strip", z.ZodTypeAny, {
        type: "shared-worker";
    }, {
        type: "shared-worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"service-worker">;
    }, "strip", z.ZodTypeAny, {
        type: "service-worker";
    }, {
        type: "service-worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"worker">;
    }, "strip", z.ZodTypeAny, {
        type: "worker";
    }, {
        type: "worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"paint-worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "paint-worklet";
    }, {
        type: "paint-worklet";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"audio-worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "audio-worklet";
    }, {
        type: "audio-worklet";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "worklet";
    }, {
        type: "worklet";
    }>>>]>>;
}, "strip", z.ZodTypeAny, {
    params: ({
        origin: string;
        realm: string;
    } & {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "dedicated-worker";
        owners: [string];
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "shared-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "service-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "paint-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "audio-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worklet";
    });
    method: "script.realmCreated";
}, {
    params: ({
        origin: string;
        realm: string;
    } & {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "dedicated-worker";
        owners: [string];
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "shared-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "service-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "paint-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "audio-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worklet";
    });
    method: "script.realmCreated";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.realmDestroyed">;
    params: z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        realm: string;
    }, {
        realm: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        realm: string;
    };
    method: "script.realmDestroyed";
}, {
    params: {
        realm: string;
    };
    method: "script.realmDestroyed";
}>>]>>]>>;
export declare const CommandDataSchema: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browser.close">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "browser.close";
}, {
    params: Record<string, any>;
    method: "browser.close";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browser.createUserContext">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "browser.createUserContext";
}, {
    params: Record<string, any>;
    method: "browser.createUserContext";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browser.getUserContexts">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "browser.getUserContexts";
}, {
    params: Record<string, any>;
    method: "browser.getUserContexts";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browser.removeUserContext">;
    params: z.ZodLazy<z.ZodObject<{
        userContext: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        userContext: string;
    }, {
        userContext: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        userContext: string;
    };
    method: "browser.removeUserContext";
}, {
    params: {
        userContext: string;
    };
    method: "browser.removeUserContext";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.activate">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        context: string;
    }, {
        context: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
    };
    method: "browsingContext.activate";
}, {
    params: {
        context: string;
    };
    method: "browsingContext.activate";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.captureScreenshot">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        origin: z.ZodOptional<z.ZodDefault<z.ZodEnum<["viewport", "document"]>>>;
        format: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            type: z.ZodString;
            quality: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: string;
            quality?: number | undefined;
        }, {
            type: string;
            quality?: number | undefined;
        }>>>;
        clip: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"box">;
            x: z.ZodNumber;
            y: z.ZodNumber;
            width: z.ZodNumber;
            height: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        }, {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"element">;
            element: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                sharedId: z.ZodLazy<z.ZodString>;
                handle: z.ZodOptional<z.ZodLazy<z.ZodString>>;
            }, "strip", z.ZodTypeAny, {
                sharedId: string;
                handle?: string | undefined;
            }, {
                sharedId: string;
                handle?: string | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
        }, "strip", z.ZodTypeAny, {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        }, {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        }>>]>>>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        origin?: "viewport" | "document" | undefined;
        format?: {
            type: string;
            quality?: number | undefined;
        } | undefined;
        clip?: {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        } | {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        } | undefined;
    }, {
        context: string;
        origin?: "viewport" | "document" | undefined;
        format?: {
            type: string;
            quality?: number | undefined;
        } | undefined;
        clip?: {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        } | {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        } | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        origin?: "viewport" | "document" | undefined;
        format?: {
            type: string;
            quality?: number | undefined;
        } | undefined;
        clip?: {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        } | {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        } | undefined;
    };
    method: "browsingContext.captureScreenshot";
}, {
    params: {
        context: string;
        origin?: "viewport" | "document" | undefined;
        format?: {
            type: string;
            quality?: number | undefined;
        } | undefined;
        clip?: {
            type: "box";
            x: number;
            y: number;
            width: number;
            height: number;
        } | {
            type: "element";
            element: {
                sharedId: string;
                handle?: string | undefined;
            } & Record<string, any>;
        } | undefined;
    };
    method: "browsingContext.captureScreenshot";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.close">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        promptUnload: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        promptUnload?: boolean | undefined;
    }, {
        context: string;
        promptUnload?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        promptUnload?: boolean | undefined;
    };
    method: "browsingContext.close";
}, {
    params: {
        context: string;
        promptUnload?: boolean | undefined;
    };
    method: "browsingContext.close";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.create">;
    params: z.ZodLazy<z.ZodObject<{
        type: z.ZodLazy<z.ZodEnum<["tab", "window"]>>;
        referenceContext: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        background: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
        userContext: z.ZodOptional<z.ZodLazy<z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        type: "window" | "tab";
        background?: boolean | undefined;
        userContext?: string | undefined;
        referenceContext?: string | undefined;
    }, {
        type: "window" | "tab";
        background?: boolean | undefined;
        userContext?: string | undefined;
        referenceContext?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        type: "window" | "tab";
        background?: boolean | undefined;
        userContext?: string | undefined;
        referenceContext?: string | undefined;
    };
    method: "browsingContext.create";
}, {
    params: {
        type: "window" | "tab";
        background?: boolean | undefined;
        userContext?: string | undefined;
        referenceContext?: string | undefined;
    };
    method: "browsingContext.create";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.getTree">;
    params: z.ZodLazy<z.ZodObject<{
        maxDepth: z.ZodOptional<z.ZodNumber>;
        root: z.ZodOptional<z.ZodLazy<z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        root?: string | undefined;
        maxDepth?: number | undefined;
    }, {
        root?: string | undefined;
        maxDepth?: number | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        root?: string | undefined;
        maxDepth?: number | undefined;
    };
    method: "browsingContext.getTree";
}, {
    params: {
        root?: string | undefined;
        maxDepth?: number | undefined;
    };
    method: "browsingContext.getTree";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.handleUserPrompt">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        accept: z.ZodOptional<z.ZodBoolean>;
        userText: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        accept?: boolean | undefined;
        userText?: string | undefined;
    }, {
        context: string;
        accept?: boolean | undefined;
        userText?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        accept?: boolean | undefined;
        userText?: string | undefined;
    };
    method: "browsingContext.handleUserPrompt";
}, {
    params: {
        context: string;
        accept?: boolean | undefined;
        userText?: string | undefined;
    };
    method: "browsingContext.handleUserPrompt";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.locateNodes">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        locator: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"accessibility">;
            value: z.ZodObject<{
                name: z.ZodOptional<z.ZodString>;
                role: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                role?: string | undefined;
                name?: string | undefined;
            }, {
                role?: string | undefined;
                name?: string | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        }, {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"css">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "css";
            value: string;
        }, {
            type: "css";
            value: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"innerText">;
            value: z.ZodString;
            ignoreCase: z.ZodOptional<z.ZodBoolean>;
            matchType: z.ZodOptional<z.ZodEnum<["full", "partial"]>>;
            maxDepth: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        }, {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"xpath">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "xpath";
            value: string;
        }, {
            type: "xpath";
            value: string;
        }>>]>>;
        maxNodeCount: z.ZodOptional<z.ZodNumber>;
        serializationOptions: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            maxDomDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            maxObjectDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            includeShadowTree: z.ZodOptional<z.ZodDefault<z.ZodEnum<["none", "open", "all"]>>>;
        }, "strip", z.ZodTypeAny, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }>>>;
        startNodes: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            sharedId: z.ZodLazy<z.ZodString>;
            handle: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            sharedId: string;
            handle?: string | undefined;
        }, {
            sharedId: string;
            handle?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        locator: {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        } | {
            type: "css";
            value: string;
        } | {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        } | {
            type: "xpath";
            value: string;
        };
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        maxNodeCount?: number | undefined;
        startNodes?: ({
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>)[] | undefined;
    }, {
        context: string;
        locator: {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        } | {
            type: "css";
            value: string;
        } | {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        } | {
            type: "xpath";
            value: string;
        };
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        maxNodeCount?: number | undefined;
        startNodes?: ({
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>)[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        locator: {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        } | {
            type: "css";
            value: string;
        } | {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        } | {
            type: "xpath";
            value: string;
        };
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        maxNodeCount?: number | undefined;
        startNodes?: ({
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>)[] | undefined;
    };
    method: "browsingContext.locateNodes";
}, {
    params: {
        context: string;
        locator: {
            type: "accessibility";
            value: {
                role?: string | undefined;
                name?: string | undefined;
            };
        } | {
            type: "css";
            value: string;
        } | {
            type: "innerText";
            value: string;
            maxDepth?: number | undefined;
            ignoreCase?: boolean | undefined;
            matchType?: "partial" | "full" | undefined;
        } | {
            type: "xpath";
            value: string;
        };
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        maxNodeCount?: number | undefined;
        startNodes?: ({
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>)[] | undefined;
    };
    method: "browsingContext.locateNodes";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigate">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        url: z.ZodString;
        wait: z.ZodOptional<z.ZodLazy<z.ZodEnum<["none", "interactive", "complete"]>>>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
    }, {
        url: string;
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
    };
    method: "browsingContext.navigate";
}, {
    params: {
        url: string;
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
    };
    method: "browsingContext.navigate";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.print">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        background: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
        margin: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            bottom: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            left: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            right: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            top: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
        }, "strip", z.ZodTypeAny, {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        }, {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        }>>>;
        orientation: z.ZodOptional<z.ZodDefault<z.ZodEnum<["portrait", "landscape"]>>>;
        page: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            height: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            width: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
        }, "strip", z.ZodTypeAny, {
            width?: number | undefined;
            height?: number | undefined;
        }, {
            width?: number | undefined;
            height?: number | undefined;
        }>>>;
        pageRanges: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodNumber, z.ZodString]>, "many">>;
        scale: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
        shrinkToFit: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        orientation?: "portrait" | "landscape" | undefined;
        background?: boolean | undefined;
        margin?: {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        } | undefined;
        page?: {
            width?: number | undefined;
            height?: number | undefined;
        } | undefined;
        pageRanges?: (string | number)[] | undefined;
        scale?: number | undefined;
        shrinkToFit?: boolean | undefined;
    }, {
        context: string;
        orientation?: "portrait" | "landscape" | undefined;
        background?: boolean | undefined;
        margin?: {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        } | undefined;
        page?: {
            width?: number | undefined;
            height?: number | undefined;
        } | undefined;
        pageRanges?: (string | number)[] | undefined;
        scale?: number | undefined;
        shrinkToFit?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        orientation?: "portrait" | "landscape" | undefined;
        background?: boolean | undefined;
        margin?: {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        } | undefined;
        page?: {
            width?: number | undefined;
            height?: number | undefined;
        } | undefined;
        pageRanges?: (string | number)[] | undefined;
        scale?: number | undefined;
        shrinkToFit?: boolean | undefined;
    };
    method: "browsingContext.print";
}, {
    params: {
        context: string;
        orientation?: "portrait" | "landscape" | undefined;
        background?: boolean | undefined;
        margin?: {
            left?: number | undefined;
            right?: number | undefined;
            bottom?: number | undefined;
            top?: number | undefined;
        } | undefined;
        page?: {
            width?: number | undefined;
            height?: number | undefined;
        } | undefined;
        pageRanges?: (string | number)[] | undefined;
        scale?: number | undefined;
        shrinkToFit?: boolean | undefined;
    };
    method: "browsingContext.print";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.reload">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        ignoreCache: z.ZodOptional<z.ZodBoolean>;
        wait: z.ZodOptional<z.ZodLazy<z.ZodEnum<["none", "interactive", "complete"]>>>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
        ignoreCache?: boolean | undefined;
    }, {
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
        ignoreCache?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
        ignoreCache?: boolean | undefined;
    };
    method: "browsingContext.reload";
}, {
    params: {
        context: string;
        wait?: "none" | "interactive" | "complete" | undefined;
        ignoreCache?: boolean | undefined;
    };
    method: "browsingContext.reload";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.setViewport">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        viewport: z.ZodOptional<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            width: z.ZodNumber;
            height: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            width: number;
            height: number;
        }, {
            width: number;
            height: number;
        }>>, z.ZodNull]>>;
        devicePixelRatio: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>;
    }, "strip", z.ZodTypeAny, {
        context: string;
        viewport?: {
            width: number;
            height: number;
        } | null | undefined;
        devicePixelRatio?: number | null | undefined;
    }, {
        context: string;
        viewport?: {
            width: number;
            height: number;
        } | null | undefined;
        devicePixelRatio?: number | null | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        viewport?: {
            width: number;
            height: number;
        } | null | undefined;
        devicePixelRatio?: number | null | undefined;
    };
    method: "browsingContext.setViewport";
}, {
    params: {
        context: string;
        viewport?: {
            width: number;
            height: number;
        } | null | undefined;
        devicePixelRatio?: number | null | undefined;
    };
    method: "browsingContext.setViewport";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.traverseHistory">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        delta: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        context: string;
        delta: number;
    }, {
        context: string;
        delta: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        delta: number;
    };
    method: "browsingContext.traverseHistory";
}, {
    params: {
        context: string;
        delta: number;
    };
    method: "browsingContext.traverseHistory";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"input.performActions">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        actions: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"none">;
            id: z.ZodString;
            actions: z.ZodArray<z.ZodLazy<z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"pause">;
                duration: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                type: "pause";
                duration?: number | undefined;
            }, {
                type: "pause";
                duration?: number | undefined;
            }>>>, "many">;
        }, "strip", z.ZodTypeAny, {
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        }, {
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"key">;
            id: z.ZodString;
            actions: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"pause">;
                duration: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                type: "pause";
                duration?: number | undefined;
            }, {
                type: "pause";
                duration?: number | undefined;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"keyDown">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "keyDown";
                value: string;
            }, {
                type: "keyDown";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"keyUp">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "keyUp";
                value: string;
            }, {
                type: "keyUp";
                value: string;
            }>>]>>, "many">;
        }, "strip", z.ZodTypeAny, {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        }, {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"pointer">;
            id: z.ZodString;
            parameters: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                pointerType: z.ZodOptional<z.ZodDefault<z.ZodLazy<z.ZodEnum<["mouse", "pen", "touch"]>>>>;
            }, "strip", z.ZodTypeAny, {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            }, {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            }>>>;
            actions: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"pause">;
                duration: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                type: "pause";
                duration?: number | undefined;
            }, {
                type: "pause";
                duration?: number | undefined;
            }>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                type: z.ZodLiteral<"pointerDown">;
                button: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                type: "pointerDown";
                button: number;
            }, {
                type: "pointerDown";
                button: number;
            }>, z.ZodLazy<z.ZodObject<{
                width: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                height: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                pressure: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                tangentialPressure: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                twist: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                altitudeAngle: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                azimuthAngle: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            }, "strip", z.ZodTypeAny, {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }, {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }>>>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"pointerUp">;
                button: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                type: "pointerUp";
                button: number;
            }, {
                type: "pointerUp";
                button: number;
            }>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                type: z.ZodLiteral<"pointerMove">;
                x: z.ZodNumber;
                y: z.ZodNumber;
                duration: z.ZodOptional<z.ZodNumber>;
                origin: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLiteral<"viewport">, z.ZodLiteral<"pointer">, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"element">;
                    element: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        sharedId: z.ZodLazy<z.ZodString>;
                        handle: z.ZodOptional<z.ZodLazy<z.ZodString>>;
                    }, "strip", z.ZodTypeAny, {
                        sharedId: string;
                        handle?: string | undefined;
                    }, {
                        sharedId: string;
                        handle?: string | undefined;
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
                }, "strip", z.ZodTypeAny, {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                }, {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                }>>]>>>;
            }, "strip", z.ZodTypeAny, {
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            }, {
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            }>, z.ZodLazy<z.ZodObject<{
                width: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                height: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                pressure: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                tangentialPressure: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                twist: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                altitudeAngle: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
                azimuthAngle: z.ZodOptional<z.ZodDefault<z.ZodNumber>>;
            }, "strip", z.ZodTypeAny, {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }, {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }>>>>]>>, "many">;
        }, "strip", z.ZodTypeAny, {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        }, {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"wheel">;
            id: z.ZodString;
            actions: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"pause">;
                duration: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                type: "pause";
                duration?: number | undefined;
            }, {
                type: "pause";
                duration?: number | undefined;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"scroll">;
                x: z.ZodNumber;
                y: z.ZodNumber;
                deltaX: z.ZodNumber;
                deltaY: z.ZodNumber;
                duration: z.ZodOptional<z.ZodNumber>;
                origin: z.ZodOptional<z.ZodDefault<z.ZodLazy<z.ZodUnion<[z.ZodLiteral<"viewport">, z.ZodLiteral<"pointer">, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"element">;
                    element: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        sharedId: z.ZodLazy<z.ZodString>;
                        handle: z.ZodOptional<z.ZodLazy<z.ZodString>>;
                    }, "strip", z.ZodTypeAny, {
                        sharedId: string;
                        handle?: string | undefined;
                    }, {
                        sharedId: string;
                        handle?: string | undefined;
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
                }, "strip", z.ZodTypeAny, {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                }, {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                }>>]>>>>;
            }, "strip", z.ZodTypeAny, {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            }, {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            }>>]>>, "many">;
        }, "strip", z.ZodTypeAny, {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        }, {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        }>>]>>, "many">;
    }, "strip", z.ZodTypeAny, {
        context: string;
        actions: ({
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        } | {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        } | {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        } | {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        })[];
    }, {
        context: string;
        actions: ({
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        } | {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        } | {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        } | {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        })[];
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
        actions: ({
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        } | {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        } | {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        } | {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        })[];
    };
    method: "input.performActions";
}, {
    params: {
        context: string;
        actions: ({
            type: "none";
            actions: {
                type: "pause";
                duration?: number | undefined;
            }[];
            id: string;
        } | {
            type: "key";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "keyDown";
                value: string;
            } | {
                type: "keyUp";
                value: string;
            })[];
            id: string;
        } | {
            type: "pointer";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | ({
                type: "pointerDown";
                button: number;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }) | {
                type: "pointerUp";
                button: number;
            } | ({
                type: "pointerMove";
                x: number;
                y: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            } & {
                width?: number | undefined;
                height?: number | undefined;
                pressure?: number | undefined;
                tangentialPressure?: number | undefined;
                twist?: number | undefined;
                altitudeAngle?: number | undefined;
                azimuthAngle?: number | undefined;
            }))[];
            id: string;
            parameters?: {
                pointerType?: "touch" | "mouse" | "pen" | undefined;
            } | undefined;
        } | {
            type: "wheel";
            actions: ({
                type: "pause";
                duration?: number | undefined;
            } | {
                type: "scroll";
                x: number;
                y: number;
                deltaX: number;
                deltaY: number;
                duration?: number | undefined;
                origin?: "viewport" | "pointer" | {
                    type: "element";
                    element: {
                        sharedId: string;
                        handle?: string | undefined;
                    } & Record<string, any>;
                } | undefined;
            })[];
            id: string;
        })[];
    };
    method: "input.performActions";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"input.releaseActions">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        context: string;
    }, {
        context: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        context: string;
    };
    method: "input.releaseActions";
}, {
    params: {
        context: string;
    };
    method: "input.releaseActions";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"input.setFiles">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        element: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            sharedId: z.ZodLazy<z.ZodString>;
            handle: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            sharedId: string;
            handle?: string | undefined;
        }, {
            sharedId: string;
            handle?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
        files: z.ZodArray<z.ZodString, "many">;
    }, "strip", z.ZodTypeAny, {
        element: {
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>;
        context: string;
        files: string[];
    }, {
        element: {
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>;
        context: string;
        files: string[];
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        element: {
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>;
        context: string;
        files: string[];
    };
    method: "input.setFiles";
}, {
    params: {
        element: {
            sharedId: string;
            handle?: string | undefined;
        } & Record<string, any>;
        context: string;
        files: string[];
    };
    method: "input.setFiles";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.addIntercept">;
    params: z.ZodLazy<z.ZodObject<{
        phases: z.ZodArray<z.ZodLazy<z.ZodEnum<["beforeRequestSent", "responseStarted", "authRequired"]>>, "many">;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
        urlPatterns: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"pattern">;
            protocol: z.ZodOptional<z.ZodString>;
            hostname: z.ZodOptional<z.ZodString>;
            port: z.ZodOptional<z.ZodString>;
            pathname: z.ZodOptional<z.ZodString>;
            search: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        }, {
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            pattern: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            pattern: string;
        }, {
            type: "string";
            pattern: string;
        }>>]>>, "many">>;
    }, "strip", z.ZodTypeAny, {
        phases: ("beforeRequestSent" | "responseStarted" | "authRequired")[];
        contexts?: string[] | undefined;
        urlPatterns?: ({
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        } | {
            type: "string";
            pattern: string;
        })[] | undefined;
    }, {
        phases: ("beforeRequestSent" | "responseStarted" | "authRequired")[];
        contexts?: string[] | undefined;
        urlPatterns?: ({
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        } | {
            type: "string";
            pattern: string;
        })[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        phases: ("beforeRequestSent" | "responseStarted" | "authRequired")[];
        contexts?: string[] | undefined;
        urlPatterns?: ({
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        } | {
            type: "string";
            pattern: string;
        })[] | undefined;
    };
    method: "network.addIntercept";
}, {
    params: {
        phases: ("beforeRequestSent" | "responseStarted" | "authRequired")[];
        contexts?: string[] | undefined;
        urlPatterns?: ({
            type: "pattern";
            search?: string | undefined;
            protocol?: string | undefined;
            hostname?: string | undefined;
            port?: string | undefined;
            pathname?: string | undefined;
        } | {
            type: "string";
            pattern: string;
        })[] | undefined;
    };
    method: "network.addIntercept";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.continueRequest">;
    params: z.ZodLazy<z.ZodObject<{
        request: z.ZodLazy<z.ZodString>;
        body: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
        }, {
            type: "string";
            value: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"base64">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "base64";
            value: string;
        }, {
            type: "base64";
            value: string;
        }>>]>>>;
        cookies: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }>>, "many">>;
        headers: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }>>, "many">>;
        method: z.ZodOptional<z.ZodString>;
        url: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        request: string;
        url?: string | undefined;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        method?: string | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
    }, {
        request: string;
        url?: string | undefined;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        method?: string | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        request: string;
        url?: string | undefined;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        method?: string | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
    };
    method: "network.continueRequest";
}, {
    params: {
        request: string;
        url?: string | undefined;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        method?: string | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
    };
    method: "network.continueRequest";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.continueResponse">;
    params: z.ZodLazy<z.ZodObject<{
        request: z.ZodLazy<z.ZodString>;
        cookies: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
            domain: z.ZodOptional<z.ZodString>;
            httpOnly: z.ZodOptional<z.ZodBoolean>;
            expiry: z.ZodOptional<z.ZodString>;
            maxAge: z.ZodOptional<z.ZodNumber>;
            path: z.ZodOptional<z.ZodString>;
            sameSite: z.ZodOptional<z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>>;
            secure: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }>>, "many">>;
        credentials: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"password">;
            username: z.ZodString;
            password: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "password";
            password: string;
            username: string;
        }, {
            type: "password";
            password: string;
            username: string;
        }>>>;
        headers: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }>>, "many">>;
        reasonPhrase: z.ZodOptional<z.ZodString>;
        statusCode: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        credentials?: {
            type: "password";
            password: string;
            username: string;
        } | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    }, {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        credentials?: {
            type: "password";
            password: string;
            username: string;
        } | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        credentials?: {
            type: "password";
            password: string;
            username: string;
        } | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    };
    method: "network.continueResponse";
}, {
    params: {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        credentials?: {
            type: "password";
            password: string;
            username: string;
        } | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    };
    method: "network.continueResponse";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.continueWithAuth">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        request: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        request: string;
    }, {
        request: string;
    }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        action: z.ZodLiteral<"provideCredentials">;
        credentials: z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"password">;
            username: z.ZodString;
            password: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "password";
            password: string;
            username: string;
        }, {
            type: "password";
            password: string;
            username: string;
        }>>;
    }, "strip", z.ZodTypeAny, {
        credentials: {
            type: "password";
            password: string;
            username: string;
        };
        action: "provideCredentials";
    }, {
        credentials: {
            type: "password";
            password: string;
            username: string;
        };
        action: "provideCredentials";
    }>>, z.ZodLazy<z.ZodObject<{
        action: z.ZodEnum<["default", "cancel"]>;
    }, "strip", z.ZodTypeAny, {
        action: "default" | "cancel";
    }, {
        action: "default" | "cancel";
    }>>]>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        request: string;
    } & ({
        credentials: {
            type: "password";
            password: string;
            username: string;
        };
        action: "provideCredentials";
    } | {
        action: "default" | "cancel";
    });
    method: "network.continueWithAuth";
}, {
    params: {
        request: string;
    } & ({
        credentials: {
            type: "password";
            password: string;
            username: string;
        };
        action: "provideCredentials";
    } | {
        action: "default" | "cancel";
    });
    method: "network.continueWithAuth";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.failRequest">;
    params: z.ZodLazy<z.ZodObject<{
        request: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        request: string;
    }, {
        request: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        request: string;
    };
    method: "network.failRequest";
}, {
    params: {
        request: string;
    };
    method: "network.failRequest";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.provideResponse">;
    params: z.ZodLazy<z.ZodObject<{
        request: z.ZodLazy<z.ZodString>;
        body: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
        }, {
            type: "string";
            value: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"base64">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "base64";
            value: string;
        }, {
            type: "base64";
            value: string;
        }>>]>>>;
        cookies: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
            domain: z.ZodOptional<z.ZodString>;
            httpOnly: z.ZodOptional<z.ZodBoolean>;
            expiry: z.ZodOptional<z.ZodString>;
            maxAge: z.ZodOptional<z.ZodNumber>;
            path: z.ZodOptional<z.ZodString>;
            sameSite: z.ZodOptional<z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>>;
            secure: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }>>, "many">>;
        headers: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }>>, "many">>;
        reasonPhrase: z.ZodOptional<z.ZodString>;
        statusCode: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    }, {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    };
    method: "network.provideResponse";
}, {
    params: {
        request: string;
        cookies?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: string | undefined;
            maxAge?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }[] | undefined;
        body?: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        } | undefined;
        headers?: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
        }[] | undefined;
        reasonPhrase?: string | undefined;
        statusCode?: number | undefined;
    };
    method: "network.provideResponse";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.removeIntercept">;
    params: z.ZodLazy<z.ZodObject<{
        intercept: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        intercept: string;
    }, {
        intercept: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        intercept: string;
    };
    method: "network.removeIntercept";
}, {
    params: {
        intercept: string;
    };
    method: "network.removeIntercept";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.setCacheBehavior">;
    params: z.ZodLazy<z.ZodObject<{
        cacheBehavior: z.ZodEnum<["default", "bypass"]>;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        cacheBehavior: "default" | "bypass";
        contexts?: string[] | undefined;
    }, {
        cacheBehavior: "default" | "bypass";
        contexts?: string[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        cacheBehavior: "default" | "bypass";
        contexts?: string[] | undefined;
    };
    method: "network.setCacheBehavior";
}, {
    params: {
        cacheBehavior: "default" | "bypass";
        contexts?: string[] | undefined;
    };
    method: "network.setCacheBehavior";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.addPreloadScript">;
    params: z.ZodLazy<z.ZodObject<{
        functionDeclaration: z.ZodString;
        arguments: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"channel">;
            value: z.ZodLazy<z.ZodObject<{
                channel: z.ZodLazy<z.ZodString>;
                serializationOptions: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                    maxDomDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
                    maxObjectDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
                    includeShadowTree: z.ZodOptional<z.ZodDefault<z.ZodEnum<["none", "open", "all"]>>>;
                }, "strip", z.ZodTypeAny, {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                }, {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                }>>>;
                ownership: z.ZodOptional<z.ZodLazy<z.ZodEnum<["root", "none"]>>>;
            }, "strip", z.ZodTypeAny, {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            }, {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }, {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }>>, "many">>;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
        sandbox: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        functionDeclaration: string;
        contexts?: string[] | undefined;
        sandbox?: string | undefined;
        arguments?: {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }[] | undefined;
    }, {
        functionDeclaration: string;
        contexts?: string[] | undefined;
        sandbox?: string | undefined;
        arguments?: {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        functionDeclaration: string;
        contexts?: string[] | undefined;
        sandbox?: string | undefined;
        arguments?: {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }[] | undefined;
    };
    method: "script.addPreloadScript";
}, {
    params: {
        functionDeclaration: string;
        contexts?: string[] | undefined;
        sandbox?: string | undefined;
        arguments?: {
            type: "channel";
            value: {
                channel: string;
                serializationOptions?: {
                    maxDomDepth?: number | null | undefined;
                    maxObjectDepth?: number | null | undefined;
                    includeShadowTree?: "none" | "all" | "open" | undefined;
                } | undefined;
                ownership?: "none" | "root" | undefined;
            };
        }[] | undefined;
    };
    method: "script.addPreloadScript";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.callFunction">;
    params: z.ZodLazy<z.ZodObject<{
        functionDeclaration: z.ZodString;
        awaitPromise: z.ZodBoolean;
        target: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            context: z.ZodLazy<z.ZodString>;
            sandbox: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            context: string;
            sandbox?: string | undefined;
        }, {
            context: string;
            sandbox?: string | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
        }, {
            realm: string;
        }>>]>>;
        arguments: z.ZodOptional<z.ZodArray<z.ZodLazy<any>, "many">>;
        resultOwnership: z.ZodOptional<z.ZodLazy<z.ZodEnum<["root", "none"]>>>;
        serializationOptions: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            maxDomDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            maxObjectDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            includeShadowTree: z.ZodOptional<z.ZodDefault<z.ZodEnum<["none", "open", "all"]>>>;
        }, "strip", z.ZodTypeAny, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }>>>;
        this: any;
        userActivation: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
    }, "strip", z.ZodTypeAny, {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        functionDeclaration: string;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
        arguments?: any[] | undefined;
        this?: any;
    }, {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        functionDeclaration: string;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
        arguments?: any[] | undefined;
        this?: any;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        functionDeclaration: string;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
        arguments?: any[] | undefined;
        this?: any;
    };
    method: "script.callFunction";
}, {
    params: {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        functionDeclaration: string;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
        arguments?: any[] | undefined;
        this?: any;
    };
    method: "script.callFunction";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.disown">;
    params: z.ZodLazy<z.ZodObject<{
        handles: z.ZodArray<z.ZodLazy<z.ZodString>, "many">;
        target: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            context: z.ZodLazy<z.ZodString>;
            sandbox: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            context: string;
            sandbox?: string | undefined;
        }, {
            context: string;
            sandbox?: string | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
        }, {
            realm: string;
        }>>]>>;
    }, "strip", z.ZodTypeAny, {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        handles: string[];
    }, {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        handles: string[];
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        handles: string[];
    };
    method: "script.disown";
}, {
    params: {
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        handles: string[];
    };
    method: "script.disown";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.evaluate">;
    params: z.ZodLazy<z.ZodObject<{
        expression: z.ZodString;
        target: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            context: z.ZodLazy<z.ZodString>;
            sandbox: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            context: string;
            sandbox?: string | undefined;
        }, {
            context: string;
            sandbox?: string | undefined;
        }>>, z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
        }, {
            realm: string;
        }>>]>>;
        awaitPromise: z.ZodBoolean;
        resultOwnership: z.ZodOptional<z.ZodLazy<z.ZodEnum<["root", "none"]>>>;
        serializationOptions: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            maxDomDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            maxObjectDepth: z.ZodOptional<z.ZodDefault<z.ZodUnion<[z.ZodNumber, z.ZodNull]>>>;
            includeShadowTree: z.ZodOptional<z.ZodDefault<z.ZodEnum<["none", "open", "all"]>>>;
        }, "strip", z.ZodTypeAny, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }, {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        }>>>;
        userActivation: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
    }, "strip", z.ZodTypeAny, {
        expression: string;
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
    }, {
        expression: string;
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        expression: string;
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
    };
    method: "script.evaluate";
}, {
    params: {
        expression: string;
        target: {
            context: string;
            sandbox?: string | undefined;
        } | {
            realm: string;
        };
        awaitPromise: boolean;
        resultOwnership?: "none" | "root" | undefined;
        serializationOptions?: {
            maxDomDepth?: number | null | undefined;
            maxObjectDepth?: number | null | undefined;
            includeShadowTree?: "none" | "all" | "open" | undefined;
        } | undefined;
        userActivation?: boolean | undefined;
    };
    method: "script.evaluate";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.getRealms">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        type: z.ZodOptional<z.ZodLazy<z.ZodEnum<["window", "dedicated-worker", "shared-worker", "service-worker", "worker", "paint-worklet", "audio-worklet", "worklet"]>>>;
    }, "strip", z.ZodTypeAny, {
        type?: "worker" | "window" | "dedicated-worker" | "shared-worker" | "service-worker" | "paint-worklet" | "audio-worklet" | "worklet" | undefined;
        context?: string | undefined;
    }, {
        type?: "worker" | "window" | "dedicated-worker" | "shared-worker" | "service-worker" | "paint-worklet" | "audio-worklet" | "worklet" | undefined;
        context?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        type?: "worker" | "window" | "dedicated-worker" | "shared-worker" | "service-worker" | "paint-worklet" | "audio-worklet" | "worklet" | undefined;
        context?: string | undefined;
    };
    method: "script.getRealms";
}, {
    params: {
        type?: "worker" | "window" | "dedicated-worker" | "shared-worker" | "service-worker" | "paint-worklet" | "audio-worklet" | "worklet" | undefined;
        context?: string | undefined;
    };
    method: "script.getRealms";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.removePreloadScript">;
    params: z.ZodLazy<z.ZodObject<{
        script: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        script: string;
    }, {
        script: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        script: string;
    };
    method: "script.removePreloadScript";
}, {
    params: {
        script: string;
    };
    method: "script.removePreloadScript";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.end">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "session.end";
}, {
    params: Record<string, any>;
    method: "session.end";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.new">;
    params: z.ZodLazy<z.ZodObject<{
        capabilities: z.ZodLazy<z.ZodObject<{
            alwaysMatch: z.ZodOptional<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
                browserName: z.ZodOptional<z.ZodString>;
                browserVersion: z.ZodOptional<z.ZodString>;
                platformName: z.ZodOptional<z.ZodString>;
                proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"autodetect">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "autodetect";
                }, {
                    proxyType: "autodetect";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"direct">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "direct";
                }, {
                    proxyType: "direct";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"manual">;
                    ftpProxy: z.ZodOptional<z.ZodString>;
                    httpProxy: z.ZodOptional<z.ZodString>;
                    sslProxy: z.ZodOptional<z.ZodString>;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    socksProxy: z.ZodString;
                    socksVersion: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    socksProxy: string;
                    socksVersion: number;
                }, {
                    socksProxy: string;
                    socksVersion: number;
                }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                    noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                }, "strip", z.ZodTypeAny, {
                    noProxy?: string[] | undefined;
                }, {
                    noProxy?: string[] | undefined;
                }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"pac">;
                    proxyAutoconfigUrl: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"system">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "system";
                }, {
                    proxyType: "system";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
                unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                    alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                }, "strip", z.ZodTypeAny, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }>>>;
            }, "strip", z.ZodTypeAny, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>>;
            firstMatch: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
                browserName: z.ZodOptional<z.ZodString>;
                browserVersion: z.ZodOptional<z.ZodString>;
                platformName: z.ZodOptional<z.ZodString>;
                proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"autodetect">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "autodetect";
                }, {
                    proxyType: "autodetect";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"direct">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "direct";
                }, {
                    proxyType: "direct";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"manual">;
                    ftpProxy: z.ZodOptional<z.ZodString>;
                    httpProxy: z.ZodOptional<z.ZodString>;
                    sslProxy: z.ZodOptional<z.ZodString>;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    socksProxy: z.ZodString;
                    socksVersion: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    socksProxy: string;
                    socksVersion: number;
                }, {
                    socksProxy: string;
                    socksVersion: number;
                }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                    noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                }, "strip", z.ZodTypeAny, {
                    noProxy?: string[] | undefined;
                }, {
                    noProxy?: string[] | undefined;
                }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"pac">;
                    proxyAutoconfigUrl: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"system">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "system";
                }, {
                    proxyType: "system";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
                unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                    alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                }, "strip", z.ZodTypeAny, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }>>>;
            }, "strip", z.ZodTypeAny, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        }, {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    }, {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    };
    method: "session.new";
}, {
    params: {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    };
    method: "session.new";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.status">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "session.status";
}, {
    params: Record<string, any>;
    method: "session.status";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.subscribe">;
    params: z.ZodLazy<z.ZodObject<{
        events: z.ZodArray<z.ZodString, "many">;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        events: string[];
        contexts?: string[] | undefined;
    }, {
        events: string[];
        contexts?: string[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.subscribe";
}, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.subscribe";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.unsubscribe">;
    params: z.ZodLazy<z.ZodObject<{
        events: z.ZodArray<z.ZodString, "many">;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        events: string[];
        contexts?: string[] | undefined;
    }, {
        events: string[];
        contexts?: string[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.unsubscribe";
}, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.unsubscribe";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"storage.deleteCookies">;
    params: z.ZodLazy<z.ZodObject<{
        filter: z.ZodOptional<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            name: z.ZodOptional<z.ZodString>;
            value: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>>;
            domain: z.ZodOptional<z.ZodString>;
            path: z.ZodOptional<z.ZodString>;
            size: z.ZodOptional<z.ZodNumber>;
            httpOnly: z.ZodOptional<z.ZodBoolean>;
            secure: z.ZodOptional<z.ZodBoolean>;
            sameSite: z.ZodOptional<z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>>;
            expiry: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }, {
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>>;
        partition: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"context">;
            context: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "context";
            context: string;
        }, {
            type: "context";
            context: string;
        }>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            type: z.ZodLiteral<"storageKey">;
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>]>>>;
    }, "strip", z.ZodTypeAny, {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }, {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.deleteCookies";
}, {
    params: {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.deleteCookies";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"storage.getCookies">;
    params: z.ZodLazy<z.ZodObject<{
        filter: z.ZodOptional<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            name: z.ZodOptional<z.ZodString>;
            value: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>>;
            domain: z.ZodOptional<z.ZodString>;
            path: z.ZodOptional<z.ZodString>;
            size: z.ZodOptional<z.ZodNumber>;
            httpOnly: z.ZodOptional<z.ZodBoolean>;
            secure: z.ZodOptional<z.ZodBoolean>;
            sameSite: z.ZodOptional<z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>>;
            expiry: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }, {
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>>;
        partition: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"context">;
            context: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "context";
            context: string;
        }, {
            type: "context";
            context: string;
        }>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            type: z.ZodLiteral<"storageKey">;
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>]>>>;
    }, "strip", z.ZodTypeAny, {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }, {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.getCookies";
}, {
    params: {
        filter?: ({
            path?: string | undefined;
            value?: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            } | undefined;
            size?: number | undefined;
            secure?: boolean | undefined;
            name?: string | undefined;
            domain?: string | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>) | undefined;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.getCookies";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"storage.setCookie">;
    params: z.ZodLazy<z.ZodObject<{
        cookie: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
            domain: z.ZodString;
            path: z.ZodOptional<z.ZodString>;
            httpOnly: z.ZodOptional<z.ZodBoolean>;
            secure: z.ZodOptional<z.ZodBoolean>;
            sameSite: z.ZodOptional<z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>>;
            expiry: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }, {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
        partition: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"context">;
            context: z.ZodLazy<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "context";
            context: string;
        }, {
            type: "context";
            context: string;
        }>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            type: z.ZodLiteral<"storageKey">;
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>]>>>;
    }, "strip", z.ZodTypeAny, {
        cookie: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }, {
        cookie: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        cookie: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.setCookie";
}, {
    params: {
        cookie: {
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            name: string;
            domain: string;
            path?: string | undefined;
            secure?: boolean | undefined;
            httpOnly?: boolean | undefined;
            expiry?: number | undefined;
            sameSite?: "strict" | "none" | "lax" | undefined;
        } & Record<string, any>;
        partition?: {
            type: "context";
            context: string;
        } | ({
            type: "storageKey";
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>) | undefined;
    };
    method: "storage.setCookie";
}>>]>>]>>;
export declare const ResultDataSchema: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    data: z.ZodString;
}, "strip", z.ZodTypeAny, {
    data: string;
}, {
    data: string;
}>>, z.ZodLazy<z.ZodObject<{
    context: z.ZodLazy<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    context: string;
}, {
    context: string;
}>>, z.ZodLazy<z.ZodObject<{
    contexts: any;
}, "strip", z.ZodTypeAny, {
    contexts?: any;
}, {
    contexts?: any;
}>>, z.ZodLazy<z.ZodObject<{
    nodes: z.ZodArray<any, "many">;
}, "strip", z.ZodTypeAny, {
    nodes: any[];
}, {
    nodes: any[];
}>>, z.ZodLazy<z.ZodObject<{
    navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
    url: z.ZodString;
}, "strip", z.ZodTypeAny, {
    url: string;
    navigation: string | null;
}, {
    url: string;
    navigation: string | null;
}>>, z.ZodLazy<z.ZodObject<{
    data: z.ZodString;
}, "strip", z.ZodTypeAny, {
    data: string;
}, {
    data: string;
}>>, z.ZodLazy<z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>>]>>, z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>, z.ZodLazy<z.ZodLazy<z.ZodObject<{
    intercept: z.ZodLazy<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    intercept: string;
}, {
    intercept: string;
}>>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    script: z.ZodLazy<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    script: string;
}, {
    script: string;
}>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    type: z.ZodLiteral<"success">;
    result: any;
    realm: z.ZodLazy<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "success";
    realm: string;
    result?: any;
}, {
    type: "success";
    realm: string;
    result?: any;
}>>, z.ZodLazy<z.ZodObject<{
    type: z.ZodLiteral<"exception">;
    exceptionDetails: z.ZodLazy<z.ZodObject<{
        columnNumber: z.ZodNumber;
        exception: any;
        lineNumber: z.ZodNumber;
        stackTrace: z.ZodLazy<z.ZodObject<{
            callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                columnNumber: z.ZodNumber;
                functionName: z.ZodString;
                lineNumber: z.ZodNumber;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }>>, "many">;
        }, "strip", z.ZodTypeAny, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }>>;
        text: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        columnNumber: number;
        lineNumber: number;
        text: string;
        stackTrace: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        };
        exception?: any;
    }, {
        columnNumber: number;
        lineNumber: number;
        text: string;
        stackTrace: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        };
        exception?: any;
    }>>;
    realm: z.ZodLazy<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "exception";
    realm: string;
    exceptionDetails: {
        columnNumber: number;
        lineNumber: number;
        text: string;
        stackTrace: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        };
        exception?: any;
    };
}, {
    type: "exception";
    realm: string;
    exceptionDetails: {
        columnNumber: number;
        lineNumber: number;
        text: string;
        stackTrace: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        };
        exception?: any;
    };
}>>]>>, z.ZodLazy<z.ZodObject<{
    realms: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"window">;
        context: z.ZodLazy<z.ZodString>;
        sandbox: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }, {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"dedicated-worker">;
        owners: z.ZodTuple<[z.ZodLazy<z.ZodString>], null>;
    }, "strip", z.ZodTypeAny, {
        type: "dedicated-worker";
        owners: [string];
    }, {
        type: "dedicated-worker";
        owners: [string];
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"shared-worker">;
    }, "strip", z.ZodTypeAny, {
        type: "shared-worker";
    }, {
        type: "shared-worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"service-worker">;
    }, "strip", z.ZodTypeAny, {
        type: "service-worker";
    }, {
        type: "service-worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"worker">;
    }, "strip", z.ZodTypeAny, {
        type: "worker";
    }, {
        type: "worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"paint-worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "paint-worklet";
    }, {
        type: "paint-worklet";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"audio-worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "audio-worklet";
    }, {
        type: "audio-worklet";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "worklet";
    }, {
        type: "worklet";
    }>>>]>>, "many">;
}, "strip", z.ZodTypeAny, {
    realms: (({
        origin: string;
        realm: string;
    } & {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "dedicated-worker";
        owners: [string];
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "shared-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "service-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "paint-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "audio-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worklet";
    }))[];
}, {
    realms: (({
        origin: string;
        realm: string;
    } & {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "dedicated-worker";
        owners: [string];
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "shared-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "service-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "paint-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "audio-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worklet";
    }))[];
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    sessionId: z.ZodString;
    capabilities: z.ZodIntersection<z.ZodObject<{
        acceptInsecureCerts: z.ZodBoolean;
        browserName: z.ZodString;
        browserVersion: z.ZodString;
        platformName: z.ZodString;
        setWindowRect: z.ZodBoolean;
        userAgent: z.ZodString;
        proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"autodetect">;
        }, "strip", z.ZodTypeAny, {
            proxyType: "autodetect";
        }, {
            proxyType: "autodetect";
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"direct">;
        }, "strip", z.ZodTypeAny, {
            proxyType: "direct";
        }, {
            proxyType: "direct";
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"manual">;
            ftpProxy: z.ZodOptional<z.ZodString>;
            httpProxy: z.ZodOptional<z.ZodString>;
            sslProxy: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        }, {
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            socksProxy: z.ZodString;
            socksVersion: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            socksProxy: string;
            socksVersion: number;
        }, {
            socksProxy: string;
            socksVersion: number;
        }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
            noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            noProxy?: string[] | undefined;
        }, {
            noProxy?: string[] | undefined;
        }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"pac">;
            proxyAutoconfigUrl: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        }, {
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"system">;
        }, "strip", z.ZodTypeAny, {
            proxyType: "system";
        }, {
            proxyType: "system";
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
        unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
        }, "strip", z.ZodTypeAny, {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        }, {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        }>>>;
        webSocketUrl: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        acceptInsecureCerts: boolean;
        browserName: string;
        browserVersion: string;
        platformName: string;
        setWindowRect: boolean;
        userAgent: string;
        proxy?: ({
            proxyType: "autodetect";
        } & Record<string, any>) | ({
            proxyType: "direct";
        } & Record<string, any>) | ((({
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        } & ({
            socksProxy: string;
            socksVersion: number;
        } | {})) & {
            noProxy?: string[] | undefined;
        }) & Record<string, any>) | ({
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        } & Record<string, any>) | ({
            proxyType: "system";
        } & Record<string, any>) | {} | undefined;
        unhandledPromptBehavior?: {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        } | undefined;
        webSocketUrl?: string | undefined;
    }, {
        acceptInsecureCerts: boolean;
        browserName: string;
        browserVersion: string;
        platformName: string;
        setWindowRect: boolean;
        userAgent: string;
        proxy?: ({
            proxyType: "autodetect";
        } & Record<string, any>) | ({
            proxyType: "direct";
        } & Record<string, any>) | ((({
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        } & ({
            socksProxy: string;
            socksVersion: number;
        } | {})) & {
            noProxy?: string[] | undefined;
        }) & Record<string, any>) | ({
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        } & Record<string, any>) | ({
            proxyType: "system";
        } & Record<string, any>) | {} | undefined;
        unhandledPromptBehavior?: {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        } | undefined;
        webSocketUrl?: string | undefined;
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    capabilities: {
        acceptInsecureCerts: boolean;
        browserName: string;
        browserVersion: string;
        platformName: string;
        setWindowRect: boolean;
        userAgent: string;
        proxy?: ({
            proxyType: "autodetect";
        } & Record<string, any>) | ({
            proxyType: "direct";
        } & Record<string, any>) | ((({
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        } & ({
            socksProxy: string;
            socksVersion: number;
        } | {})) & {
            noProxy?: string[] | undefined;
        }) & Record<string, any>) | ({
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        } & Record<string, any>) | ({
            proxyType: "system";
        } & Record<string, any>) | {} | undefined;
        unhandledPromptBehavior?: {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        } | undefined;
        webSocketUrl?: string | undefined;
    } & Record<string, any>;
    sessionId: string;
}, {
    capabilities: {
        acceptInsecureCerts: boolean;
        browserName: string;
        browserVersion: string;
        platformName: string;
        setWindowRect: boolean;
        userAgent: string;
        proxy?: ({
            proxyType: "autodetect";
        } & Record<string, any>) | ({
            proxyType: "direct";
        } & Record<string, any>) | ((({
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        } & ({
            socksProxy: string;
            socksVersion: number;
        } | {})) & {
            noProxy?: string[] | undefined;
        }) & Record<string, any>) | ({
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        } & Record<string, any>) | ({
            proxyType: "system";
        } & Record<string, any>) | {} | undefined;
        unhandledPromptBehavior?: {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        } | undefined;
        webSocketUrl?: string | undefined;
    } & Record<string, any>;
    sessionId: string;
}>>, z.ZodLazy<z.ZodObject<{
    ready: z.ZodBoolean;
    message: z.ZodString;
}, "strip", z.ZodTypeAny, {
    message: string;
    ready: boolean;
}, {
    message: string;
    ready: boolean;
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    partitionKey: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        userContext: z.ZodOptional<z.ZodString>;
        sourceOrigin: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    }, {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
}, "strip", z.ZodTypeAny, {
    partitionKey: {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    } & Record<string, any>;
}, {
    partitionKey: {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    } & Record<string, any>;
}>>, z.ZodLazy<z.ZodObject<{
    cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        name: z.ZodString;
        value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"string">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            value: string;
        }, {
            type: "string";
            value: string;
        }>>, z.ZodLazy<z.ZodObject<{
            type: z.ZodLiteral<"base64">;
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "base64";
            value: string;
        }, {
            type: "base64";
            value: string;
        }>>]>>;
        domain: z.ZodString;
        path: z.ZodString;
        size: z.ZodNumber;
        httpOnly: z.ZodBoolean;
        secure: z.ZodBoolean;
        sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
        expiry: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        path: string;
        value: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        };
        size: number;
        secure: boolean;
        name: string;
        domain: string;
        httpOnly: boolean;
        sameSite: "strict" | "none" | "lax";
        expiry?: number | undefined;
    }, {
        path: string;
        value: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        };
        size: number;
        secure: boolean;
        name: string;
        domain: string;
        httpOnly: boolean;
        sameSite: "strict" | "none" | "lax";
        expiry?: number | undefined;
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
    partitionKey: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        userContext: z.ZodOptional<z.ZodString>;
        sourceOrigin: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    }, {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
}, "strip", z.ZodTypeAny, {
    cookies: ({
        path: string;
        value: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        };
        size: number;
        secure: boolean;
        name: string;
        domain: string;
        httpOnly: boolean;
        sameSite: "strict" | "none" | "lax";
        expiry?: number | undefined;
    } & Record<string, any>)[];
    partitionKey: {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    } & Record<string, any>;
}, {
    cookies: ({
        path: string;
        value: {
            type: "string";
            value: string;
        } | {
            type: "base64";
            value: string;
        };
        size: number;
        secure: boolean;
        name: string;
        domain: string;
        httpOnly: boolean;
        sameSite: "strict" | "none" | "lax";
        expiry?: number | undefined;
    } & Record<string, any>)[];
    partitionKey: {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    } & Record<string, any>;
}>>, z.ZodLazy<z.ZodObject<{
    partitionKey: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        userContext: z.ZodOptional<z.ZodString>;
        sourceOrigin: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    }, {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
}, "strip", z.ZodTypeAny, {
    partitionKey: {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    } & Record<string, any>;
}, {
    partitionKey: {
        userContext?: string | undefined;
        sourceOrigin?: string | undefined;
    } & Record<string, any>;
}>>]>>]>>;
export declare const EmptyParamsSchema: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
export declare const MessageSchema: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
    type: z.ZodLiteral<"success">;
    id: z.ZodNumber;
    result: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
    }, {
        data: string;
    }>>, z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        context: string;
    }, {
        context: string;
    }>>, z.ZodLazy<z.ZodObject<{
        contexts: any;
    }, "strip", z.ZodTypeAny, {
        contexts?: any;
    }, {
        contexts?: any;
    }>>, z.ZodLazy<z.ZodObject<{
        nodes: z.ZodArray<any, "many">;
    }, "strip", z.ZodTypeAny, {
        nodes: any[];
    }, {
        nodes: any[];
    }>>, z.ZodLazy<z.ZodObject<{
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
    }, {
        url: string;
        navigation: string | null;
    }>>, z.ZodLazy<z.ZodObject<{
        data: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        data: string;
    }, {
        data: string;
    }>>, z.ZodLazy<z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>>]>>, z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>, z.ZodLazy<z.ZodLazy<z.ZodObject<{
        intercept: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        intercept: string;
    }, {
        intercept: string;
    }>>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        script: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        script: string;
    }, {
        script: string;
    }>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        type: z.ZodLiteral<"success">;
        result: any;
        realm: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "success";
        realm: string;
        result?: any;
    }, {
        type: "success";
        realm: string;
        result?: any;
    }>>, z.ZodLazy<z.ZodObject<{
        type: z.ZodLiteral<"exception">;
        exceptionDetails: z.ZodLazy<z.ZodObject<{
            columnNumber: z.ZodNumber;
            exception: any;
            lineNumber: z.ZodNumber;
            stackTrace: z.ZodLazy<z.ZodObject<{
                callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                    columnNumber: z.ZodNumber;
                    functionName: z.ZodString;
                    lineNumber: z.ZodNumber;
                    url: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }, {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }>>, "many">;
            }, "strip", z.ZodTypeAny, {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            }, {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            }>>;
            text: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        }, {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        }>>;
        realm: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "exception";
        realm: string;
        exceptionDetails: {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        };
    }, {
        type: "exception";
        realm: string;
        exceptionDetails: {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        };
    }>>]>>, z.ZodLazy<z.ZodObject<{
        realms: z.ZodArray<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"window">;
            context: z.ZodLazy<z.ZodString>;
            sandbox: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }, {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"dedicated-worker">;
            owners: z.ZodTuple<[z.ZodLazy<z.ZodString>], null>;
        }, "strip", z.ZodTypeAny, {
            type: "dedicated-worker";
            owners: [string];
        }, {
            type: "dedicated-worker";
            owners: [string];
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"shared-worker">;
        }, "strip", z.ZodTypeAny, {
            type: "shared-worker";
        }, {
            type: "shared-worker";
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"service-worker">;
        }, "strip", z.ZodTypeAny, {
            type: "service-worker";
        }, {
            type: "service-worker";
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"worker">;
        }, "strip", z.ZodTypeAny, {
            type: "worker";
        }, {
            type: "worker";
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"paint-worklet">;
        }, "strip", z.ZodTypeAny, {
            type: "paint-worklet";
        }, {
            type: "paint-worklet";
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"audio-worklet">;
        }, "strip", z.ZodTypeAny, {
            type: "audio-worklet";
        }, {
            type: "audio-worklet";
        }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            origin: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            origin: string;
            realm: string;
        }, {
            origin: string;
            realm: string;
        }>>, z.ZodObject<{
            type: z.ZodLiteral<"worklet">;
        }, "strip", z.ZodTypeAny, {
            type: "worklet";
        }, {
            type: "worklet";
        }>>>]>>, "many">;
    }, "strip", z.ZodTypeAny, {
        realms: (({
            origin: string;
            realm: string;
        } & {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "dedicated-worker";
            owners: [string];
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "shared-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "service-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "paint-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "audio-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worklet";
        }))[];
    }, {
        realms: (({
            origin: string;
            realm: string;
        } & {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "dedicated-worker";
            owners: [string];
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "shared-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "service-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "paint-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "audio-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worklet";
        }))[];
    }>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        sessionId: z.ZodString;
        capabilities: z.ZodIntersection<z.ZodObject<{
            acceptInsecureCerts: z.ZodBoolean;
            browserName: z.ZodString;
            browserVersion: z.ZodString;
            platformName: z.ZodString;
            setWindowRect: z.ZodBoolean;
            userAgent: z.ZodString;
            proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"autodetect">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "autodetect";
            }, {
                proxyType: "autodetect";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"direct">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "direct";
            }, {
                proxyType: "direct";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"manual">;
                ftpProxy: z.ZodOptional<z.ZodString>;
                httpProxy: z.ZodOptional<z.ZodString>;
                sslProxy: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            }, {
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                socksProxy: z.ZodString;
                socksVersion: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                socksProxy: string;
                socksVersion: number;
            }, {
                socksProxy: string;
                socksVersion: number;
            }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                noProxy?: string[] | undefined;
            }, {
                noProxy?: string[] | undefined;
            }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"pac">;
                proxyAutoconfigUrl: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            }, {
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"system">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "system";
            }, {
                proxyType: "system";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
            unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            }, "strip", z.ZodTypeAny, {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            }, {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            }>>>;
            webSocketUrl: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        }, {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
    }, "strip", z.ZodTypeAny, {
        capabilities: {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        } & Record<string, any>;
        sessionId: string;
    }, {
        capabilities: {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        } & Record<string, any>;
        sessionId: string;
    }>>, z.ZodLazy<z.ZodObject<{
        ready: z.ZodBoolean;
        message: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        message: string;
        ready: boolean;
    }, {
        message: string;
        ready: boolean;
    }>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        partitionKey: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
    }, "strip", z.ZodTypeAny, {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }, {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }>>, z.ZodLazy<z.ZodObject<{
        cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            name: z.ZodString;
            value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"string">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                value: string;
            }, {
                type: "string";
                value: string;
            }>>, z.ZodLazy<z.ZodObject<{
                type: z.ZodLiteral<"base64">;
                value: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                type: "base64";
                value: string;
            }, {
                type: "base64";
                value: string;
            }>>]>>;
            domain: z.ZodString;
            path: z.ZodString;
            size: z.ZodNumber;
            httpOnly: z.ZodBoolean;
            secure: z.ZodBoolean;
            sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
            expiry: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        }, {
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
        partitionKey: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
    }, "strip", z.ZodTypeAny, {
        cookies: ({
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        } & Record<string, any>)[];
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }, {
        cookies: ({
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        } & Record<string, any>)[];
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }>>, z.ZodLazy<z.ZodObject<{
        partitionKey: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            userContext: z.ZodOptional<z.ZodString>;
            sourceOrigin: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }, {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
    }, "strip", z.ZodTypeAny, {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }, {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    }>>]>>]>>;
}, "strip", z.ZodTypeAny, {
    type: "success";
    id: number;
    result: Record<string, any> | {
        data: string;
    } | {
        context: string;
    } | {
        contexts?: any;
    } | {
        nodes: any[];
    } | {
        url: string;
        navigation: string | null;
    } | {
        data: string;
    } | {} | {
        intercept: string;
    } | {
        script: string;
    } | {
        type: "success";
        realm: string;
        result?: any;
    } | {
        type: "exception";
        realm: string;
        exceptionDetails: {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        };
    } | {
        realms: (({
            origin: string;
            realm: string;
        } & {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "dedicated-worker";
            owners: [string];
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "shared-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "service-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "paint-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "audio-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worklet";
        }))[];
    } | {
        capabilities: {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        } & Record<string, any>;
        sessionId: string;
    } | {
        message: string;
        ready: boolean;
    } | {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    } | {
        cookies: ({
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        } & Record<string, any>)[];
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    } | {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    };
}, {
    type: "success";
    id: number;
    result: Record<string, any> | {
        data: string;
    } | {
        context: string;
    } | {
        contexts?: any;
    } | {
        nodes: any[];
    } | {
        url: string;
        navigation: string | null;
    } | {
        data: string;
    } | {} | {
        intercept: string;
    } | {
        script: string;
    } | {
        type: "success";
        realm: string;
        result?: any;
    } | {
        type: "exception";
        realm: string;
        exceptionDetails: {
            columnNumber: number;
            lineNumber: number;
            text: string;
            stackTrace: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            };
            exception?: any;
        };
    } | {
        realms: (({
            origin: string;
            realm: string;
        } & {
            type: "window";
            context: string;
            sandbox?: string | undefined;
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "dedicated-worker";
            owners: [string];
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "shared-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "service-worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worker";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "paint-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "audio-worklet";
        }) | ({
            origin: string;
            realm: string;
        } & {
            type: "worklet";
        }))[];
    } | {
        capabilities: {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
            webSocketUrl?: string | undefined;
        } & Record<string, any>;
        sessionId: string;
    } | {
        message: string;
        ready: boolean;
    } | {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    } | {
        cookies: ({
            path: string;
            value: {
                type: "string";
                value: string;
            } | {
                type: "base64";
                value: string;
            };
            size: number;
            secure: boolean;
            name: string;
            domain: string;
            httpOnly: boolean;
            sameSite: "strict" | "none" | "lax";
            expiry?: number | undefined;
        } & Record<string, any>)[];
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    } | {
        partitionKey: {
            userContext?: string | undefined;
            sourceOrigin?: string | undefined;
        } & Record<string, any>;
    };
}>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
    type: z.ZodLiteral<"error">;
    id: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
    error: z.ZodLazy<z.ZodEnum<["invalid argument", "invalid selector", "invalid session id", "move target out of bounds", "no such alert", "no such element", "no such frame", "no such handle", "no such history entry", "no such intercept", "no such node", "no such request", "no such script", "no such storage partition", "no such user context", "session not created", "unable to capture screen", "unable to close browser", "unable to set cookie", "unable to set file input", "underspecified storage partition", "unknown command", "unknown error", "unsupported operation"]>>;
    message: z.ZodString;
    stacktrace: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    message: string;
    type: "error";
    error: "invalid argument" | "invalid selector" | "invalid session id" | "move target out of bounds" | "no such alert" | "no such element" | "no such frame" | "no such handle" | "no such history entry" | "no such intercept" | "no such node" | "no such request" | "no such script" | "no such storage partition" | "no such user context" | "session not created" | "unable to capture screen" | "unable to close browser" | "unable to set cookie" | "unable to set file input" | "underspecified storage partition" | "unknown command" | "unknown error" | "unsupported operation";
    id: number | null;
    stacktrace?: string | undefined;
}, {
    message: string;
    type: "error";
    error: "invalid argument" | "invalid selector" | "invalid session id" | "move target out of bounds" | "no such alert" | "no such element" | "no such frame" | "no such handle" | "no such history entry" | "no such intercept" | "no such node" | "no such request" | "no such script" | "no such storage partition" | "no such user context" | "session not created" | "unable to capture screen" | "unable to close browser" | "unable to set cookie" | "unable to set file input" | "underspecified storage partition" | "unknown command" | "unknown error" | "unsupported operation";
    id: number | null;
    stacktrace?: string | undefined;
}>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
    type: z.ZodLiteral<"event">;
}, "strip", z.ZodTypeAny, {
    type: "event";
}, {
    type: "event";
}>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.contextCreated">;
    params: z.ZodLazy<any>;
}, "strip", z.ZodTypeAny, {
    method: "browsingContext.contextCreated";
    params?: any;
}, {
    method: "browsingContext.contextCreated";
    params?: any;
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.contextDestroyed">;
    params: any;
}, "strip", z.ZodTypeAny, {
    method: "browsingContext.contextDestroyed";
    params?: any;
}, {
    method: "browsingContext.contextDestroyed";
    params?: any;
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.domContentLoaded">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.domContentLoaded";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.domContentLoaded";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.downloadWillBegin">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.downloadWillBegin";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.downloadWillBegin";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.fragmentNavigated">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.fragmentNavigated";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.fragmentNavigated";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.load">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.load";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.load";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigationAborted">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationAborted";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationAborted";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigationFailed">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationFailed";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationFailed";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.navigationStarted">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        timestamp: z.ZodNumber;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }, {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationStarted";
}, {
    params: {
        url: string;
        navigation: string | null;
        context: string;
        timestamp: number;
    };
    method: "browsingContext.navigationStarted";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.userPromptClosed">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        accepted: z.ZodBoolean;
        type: z.ZodLazy<z.ZodEnum<["alert", "beforeunload", "confirm", "prompt"]>>;
        userText: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    }, {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    };
    method: "browsingContext.userPromptClosed";
}, {
    params: {
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        context: string;
        accepted: boolean;
        userText?: string | undefined;
    };
    method: "browsingContext.userPromptClosed";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"browsingContext.userPromptOpened">;
    params: z.ZodLazy<z.ZodObject<{
        context: z.ZodLazy<z.ZodString>;
        handler: z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>;
        message: z.ZodString;
        type: z.ZodLazy<z.ZodEnum<["alert", "beforeunload", "confirm", "prompt"]>>;
        defaultValue: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    }, {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    };
    method: "browsingContext.userPromptOpened";
}, {
    params: {
        message: string;
        type: "prompt" | "alert" | "confirm" | "beforeunload";
        handler: "accept" | "dismiss" | "ignore";
        context: string;
        defaultValue?: string | undefined;
    };
    method: "browsingContext.userPromptOpened";
}>>]>>, z.ZodLazy<z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"log.entryAdded">;
    params: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        level: z.ZodLazy<z.ZodEnum<["debug", "info", "warn", "error"]>>;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
        text: z.ZodUnion<[z.ZodString, z.ZodNull]>;
        timestamp: z.ZodNumber;
        stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                columnNumber: z.ZodNumber;
                functionName: z.ZodString;
                lineNumber: z.ZodNumber;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }>>, "many">;
        }, "strip", z.ZodTypeAny, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }>>>;
    }, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }>>, z.ZodObject<{
        type: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        type: string;
    }, {
        type: string;
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        level: z.ZodLazy<z.ZodEnum<["debug", "info", "warn", "error"]>>;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
        text: z.ZodUnion<[z.ZodString, z.ZodNull]>;
        timestamp: z.ZodNumber;
        stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                columnNumber: z.ZodNumber;
                functionName: z.ZodString;
                lineNumber: z.ZodNumber;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }>>, "many">;
        }, "strip", z.ZodTypeAny, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }>>>;
    }, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"console">;
        method: z.ZodString;
        args: z.ZodArray<z.ZodLazy<any>, "many">;
    }, "strip", z.ZodTypeAny, {
        type: "console";
        args: any[];
        method: string;
    }, {
        type: "console";
        args: any[];
        method: string;
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        level: z.ZodLazy<z.ZodEnum<["debug", "info", "warn", "error"]>>;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
        text: z.ZodUnion<[z.ZodString, z.ZodNull]>;
        timestamp: z.ZodNumber;
        stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                columnNumber: z.ZodNumber;
                functionName: z.ZodString;
                lineNumber: z.ZodNumber;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }, {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }>>, "many">;
        }, "strip", z.ZodTypeAny, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }, {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        }>>>;
    }, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }, {
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"javascript">;
    }, "strip", z.ZodTypeAny, {
        type: "javascript";
    }, {
        type: "javascript";
    }>>>]>>;
}, "strip", z.ZodTypeAny, {
    params: ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "console";
        args: any[];
        method: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "javascript";
    });
    method: "log.entryAdded";
}, {
    params: ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "console";
        args: any[];
        method: string;
    }) | ({
        level: "error" | "debug" | "info" | "warn";
        source: {
            realm: string;
            context?: string | undefined;
        };
        text: string | null;
        timestamp: number;
        stackTrace?: {
            callFrames: {
                url: string;
                columnNumber: number;
                lineNumber: number;
                functionName: string;
            }[];
        } | undefined;
    } & {
        type: "javascript";
    });
    method: "log.entryAdded";
}>>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.authRequired">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        response: z.ZodLazy<z.ZodObject<{
            url: z.ZodString;
            protocol: z.ZodString;
            status: z.ZodNumber;
            statusText: z.ZodString;
            fromCache: z.ZodBoolean;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            mimeType: z.ZodString;
            bytesReceived: z.ZodNumber;
            headersSize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            content: z.ZodLazy<z.ZodObject<{
                size: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                size: number;
            }, {
                size: number;
            }>>;
            authChallenges: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                scheme: z.ZodString;
                realm: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                realm: string;
                scheme: string;
            }, {
                realm: string;
                scheme: string;
            }>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.authRequired";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.authRequired";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.beforeRequestSent">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        initiator: z.ZodLazy<z.ZodObject<{
            type: z.ZodEnum<["parser", "script", "preflight", "other"]>;
            columnNumber: z.ZodOptional<z.ZodNumber>;
            lineNumber: z.ZodOptional<z.ZodNumber>;
            stackTrace: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                callFrames: z.ZodArray<z.ZodLazy<z.ZodObject<{
                    columnNumber: z.ZodNumber;
                    functionName: z.ZodString;
                    lineNumber: z.ZodNumber;
                    url: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }, {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }>>, "many">;
            }, "strip", z.ZodTypeAny, {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            }, {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            }>>>;
            request: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        }, {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    }, {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    };
    method: "network.beforeRequestSent";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        initiator: {
            type: "other" | "script" | "parser" | "preflight";
            request?: string | undefined;
            columnNumber?: number | undefined;
            lineNumber?: number | undefined;
            stackTrace?: {
                callFrames: {
                    url: string;
                    columnNumber: number;
                    lineNumber: number;
                    functionName: string;
                }[];
            } | undefined;
        };
    };
    method: "network.beforeRequestSent";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.fetchError">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        errorText: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        errorText: string;
    }, {
        errorText: string;
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        errorText: string;
    };
    method: "network.fetchError";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        errorText: string;
    };
    method: "network.fetchError";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.responseCompleted">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        response: z.ZodLazy<z.ZodObject<{
            url: z.ZodString;
            protocol: z.ZodString;
            status: z.ZodNumber;
            statusText: z.ZodString;
            fromCache: z.ZodBoolean;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            mimeType: z.ZodString;
            bytesReceived: z.ZodNumber;
            headersSize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            content: z.ZodLazy<z.ZodObject<{
                size: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                size: number;
            }, {
                size: number;
            }>>;
            authChallenges: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                scheme: z.ZodString;
                realm: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                realm: string;
                scheme: string;
            }, {
                realm: string;
                scheme: string;
            }>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseCompleted";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseCompleted";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"network.responseStarted">;
    params: z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        context: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        isBlocked: z.ZodBoolean;
        navigation: z.ZodUnion<[z.ZodLazy<z.ZodString>, z.ZodNull]>;
        redirectCount: z.ZodNumber;
        request: z.ZodLazy<z.ZodObject<{
            request: z.ZodLazy<z.ZodString>;
            url: z.ZodString;
            method: z.ZodString;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            cookies: z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
                domain: z.ZodString;
                path: z.ZodString;
                size: z.ZodNumber;
                httpOnly: z.ZodBoolean;
                secure: z.ZodBoolean;
                sameSite: z.ZodLazy<z.ZodEnum<["strict", "lax", "none"]>>;
                expiry: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }, {
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">;
            headersSize: z.ZodNumber;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            timings: z.ZodLazy<z.ZodObject<{
                timeOrigin: z.ZodNumber;
                requestTime: z.ZodNumber;
                redirectStart: z.ZodNumber;
                redirectEnd: z.ZodNumber;
                fetchStart: z.ZodNumber;
                dnsStart: z.ZodNumber;
                dnsEnd: z.ZodNumber;
                connectStart: z.ZodNumber;
                connectEnd: z.ZodNumber;
                tlsStart: z.ZodNumber;
                requestStart: z.ZodNumber;
                responseStart: z.ZodNumber;
                responseEnd: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }, {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }, {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        }>>;
        timestamp: z.ZodNumber;
        intercepts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }, {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    }>>, z.ZodObject<{
        response: z.ZodLazy<z.ZodObject<{
            url: z.ZodString;
            protocol: z.ZodString;
            status: z.ZodNumber;
            statusText: z.ZodString;
            fromCache: z.ZodBoolean;
            headers: z.ZodArray<z.ZodLazy<z.ZodObject<{
                name: z.ZodString;
                value: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    value: string;
                }, {
                    type: "string";
                    value: string;
                }>>, z.ZodLazy<z.ZodObject<{
                    type: z.ZodLiteral<"base64">;
                    value: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    type: "base64";
                    value: string;
                }, {
                    type: "base64";
                    value: string;
                }>>]>>;
            }, "strip", z.ZodTypeAny, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }, {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }>>, "many">;
            mimeType: z.ZodString;
            bytesReceived: z.ZodNumber;
            headersSize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            bodySize: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
            content: z.ZodLazy<z.ZodObject<{
                size: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                size: number;
            }, {
                size: number;
            }>>;
            authChallenges: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodObject<{
                scheme: z.ZodString;
                realm: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                realm: string;
                scheme: string;
            }, {
                realm: string;
                scheme: string;
            }>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }, {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }, {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    }>>>;
}, "strip", z.ZodTypeAny, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseStarted";
}, {
    params: {
        navigation: string | null;
        context: string | null;
        request: {
            url: string;
            cookies: ({
                path: string;
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                size: number;
                secure: boolean;
                name: string;
                domain: string;
                httpOnly: boolean;
                sameSite: "strict" | "none" | "lax";
                expiry?: number | undefined;
            } & Record<string, any>)[];
            method: string;
            request: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            headersSize: number;
            bodySize: number | null;
            timings: {
                timeOrigin: number;
                requestTime: number;
                redirectStart: number;
                redirectEnd: number;
                fetchStart: number;
                dnsStart: number;
                dnsEnd: number;
                connectStart: number;
                connectEnd: number;
                tlsStart: number;
                requestStart: number;
                responseStart: number;
                responseEnd: number;
            };
        };
        timestamp: number;
        isBlocked: boolean;
        redirectCount: number;
        intercepts?: string[] | undefined;
    } & {
        response: {
            url: string;
            status: number;
            protocol: string;
            headers: {
                value: {
                    type: "string";
                    value: string;
                } | {
                    type: "base64";
                    value: string;
                };
                name: string;
            }[];
            content: {
                size: number;
            };
            headersSize: number | null;
            bodySize: number | null;
            statusText: string;
            fromCache: boolean;
            mimeType: string;
            bytesReceived: number;
            authChallenges?: {
                realm: string;
                scheme: string;
            }[] | undefined;
        };
    };
    method: "network.responseStarted";
}>>]>>, z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.message">;
    params: z.ZodLazy<z.ZodObject<{
        channel: z.ZodLazy<z.ZodString>;
        data: any;
        source: z.ZodLazy<z.ZodObject<{
            realm: z.ZodLazy<z.ZodString>;
            context: z.ZodOptional<z.ZodLazy<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            realm: string;
            context?: string | undefined;
        }, {
            realm: string;
            context?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    }, {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    };
    method: "script.message";
}, {
    params: {
        channel: string;
        source: {
            realm: string;
            context?: string | undefined;
        };
        data?: any;
    };
    method: "script.message";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.realmCreated">;
    params: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"window">;
        context: z.ZodLazy<z.ZodString>;
        sandbox: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }, {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"dedicated-worker">;
        owners: z.ZodTuple<[z.ZodLazy<z.ZodString>], null>;
    }, "strip", z.ZodTypeAny, {
        type: "dedicated-worker";
        owners: [string];
    }, {
        type: "dedicated-worker";
        owners: [string];
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"shared-worker">;
    }, "strip", z.ZodTypeAny, {
        type: "shared-worker";
    }, {
        type: "shared-worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"service-worker">;
    }, "strip", z.ZodTypeAny, {
        type: "service-worker";
    }, {
        type: "service-worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"worker">;
    }, "strip", z.ZodTypeAny, {
        type: "worker";
    }, {
        type: "worker";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"paint-worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "paint-worklet";
    }, {
        type: "paint-worklet";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"audio-worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "audio-worklet";
    }, {
        type: "audio-worklet";
    }>>>, z.ZodLazy<z.ZodIntersection<z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
        origin: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        origin: string;
        realm: string;
    }, {
        origin: string;
        realm: string;
    }>>, z.ZodObject<{
        type: z.ZodLiteral<"worklet">;
    }, "strip", z.ZodTypeAny, {
        type: "worklet";
    }, {
        type: "worklet";
    }>>>]>>;
}, "strip", z.ZodTypeAny, {
    params: ({
        origin: string;
        realm: string;
    } & {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "dedicated-worker";
        owners: [string];
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "shared-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "service-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "paint-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "audio-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worklet";
    });
    method: "script.realmCreated";
}, {
    params: ({
        origin: string;
        realm: string;
    } & {
        type: "window";
        context: string;
        sandbox?: string | undefined;
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "dedicated-worker";
        owners: [string];
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "shared-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "service-worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worker";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "paint-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "audio-worklet";
    }) | ({
        origin: string;
        realm: string;
    } & {
        type: "worklet";
    });
    method: "script.realmCreated";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"script.realmDestroyed">;
    params: z.ZodLazy<z.ZodObject<{
        realm: z.ZodLazy<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        realm: string;
    }, {
        realm: string;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        realm: string;
    };
    method: "script.realmDestroyed";
}, {
    params: {
        realm: string;
    };
    method: "script.realmDestroyed";
}>>]>>]>>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>]>>;
export declare const ErrorResponseSchema: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
    type: z.ZodLiteral<"error">;
    id: z.ZodUnion<[z.ZodNumber, z.ZodNull]>;
    error: z.ZodLazy<z.ZodEnum<["invalid argument", "invalid selector", "invalid session id", "move target out of bounds", "no such alert", "no such element", "no such frame", "no such handle", "no such history entry", "no such intercept", "no such node", "no such request", "no such script", "no such storage partition", "no such user context", "session not created", "unable to capture screen", "unable to close browser", "unable to set cookie", "unable to set file input", "underspecified storage partition", "unknown command", "unknown error", "unsupported operation"]>>;
    message: z.ZodString;
    stacktrace: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    message: string;
    type: "error";
    error: "invalid argument" | "invalid selector" | "invalid session id" | "move target out of bounds" | "no such alert" | "no such element" | "no such frame" | "no such handle" | "no such history entry" | "no such intercept" | "no such node" | "no such request" | "no such script" | "no such storage partition" | "no such user context" | "session not created" | "unable to capture screen" | "unable to close browser" | "unable to set cookie" | "unable to set file input" | "underspecified storage partition" | "unknown command" | "unknown error" | "unsupported operation";
    id: number | null;
    stacktrace?: string | undefined;
}, {
    message: string;
    type: "error";
    error: "invalid argument" | "invalid selector" | "invalid session id" | "move target out of bounds" | "no such alert" | "no such element" | "no such frame" | "no such handle" | "no such history entry" | "no such intercept" | "no such node" | "no such request" | "no such script" | "no such storage partition" | "no such user context" | "session not created" | "unable to capture screen" | "unable to close browser" | "unable to set cookie" | "unable to set file input" | "underspecified storage partition" | "unknown command" | "unknown error" | "unsupported operation";
    id: number | null;
    stacktrace?: string | undefined;
}>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
export declare const EmptyResultSchema: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
export declare const ExtensibleSchema: z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>;
export declare const JsIntSchema: z.ZodNumber;
export declare const JsUintSchema: z.ZodNumber;
export declare const ErrorCodeSchema: z.ZodLazy<z.ZodEnum<["invalid argument", "invalid selector", "invalid session id", "move target out of bounds", "no such alert", "no such element", "no such frame", "no such handle", "no such history entry", "no such intercept", "no such node", "no such request", "no such script", "no such storage partition", "no such user context", "session not created", "unable to capture screen", "unable to close browser", "unable to set cookie", "unable to set file input", "underspecified storage partition", "unknown command", "unknown error", "unsupported operation"]>>;
export declare const SessionCommandSchema: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.end">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "session.end";
}, {
    params: Record<string, any>;
    method: "session.end";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.new">;
    params: z.ZodLazy<z.ZodObject<{
        capabilities: z.ZodLazy<z.ZodObject<{
            alwaysMatch: z.ZodOptional<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
                browserName: z.ZodOptional<z.ZodString>;
                browserVersion: z.ZodOptional<z.ZodString>;
                platformName: z.ZodOptional<z.ZodString>;
                proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"autodetect">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "autodetect";
                }, {
                    proxyType: "autodetect";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"direct">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "direct";
                }, {
                    proxyType: "direct";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"manual">;
                    ftpProxy: z.ZodOptional<z.ZodString>;
                    httpProxy: z.ZodOptional<z.ZodString>;
                    sslProxy: z.ZodOptional<z.ZodString>;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    socksProxy: z.ZodString;
                    socksVersion: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    socksProxy: string;
                    socksVersion: number;
                }, {
                    socksProxy: string;
                    socksVersion: number;
                }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                    noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                }, "strip", z.ZodTypeAny, {
                    noProxy?: string[] | undefined;
                }, {
                    noProxy?: string[] | undefined;
                }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"pac">;
                    proxyAutoconfigUrl: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"system">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "system";
                }, {
                    proxyType: "system";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
                unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                    alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                }, "strip", z.ZodTypeAny, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }>>>;
            }, "strip", z.ZodTypeAny, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>>;
            firstMatch: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
                browserName: z.ZodOptional<z.ZodString>;
                browserVersion: z.ZodOptional<z.ZodString>;
                platformName: z.ZodOptional<z.ZodString>;
                proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"autodetect">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "autodetect";
                }, {
                    proxyType: "autodetect";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"direct">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "direct";
                }, {
                    proxyType: "direct";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"manual">;
                    ftpProxy: z.ZodOptional<z.ZodString>;
                    httpProxy: z.ZodOptional<z.ZodString>;
                    sslProxy: z.ZodOptional<z.ZodString>;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    socksProxy: z.ZodString;
                    socksVersion: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    socksProxy: string;
                    socksVersion: number;
                }, {
                    socksProxy: string;
                    socksVersion: number;
                }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                    noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                }, "strip", z.ZodTypeAny, {
                    noProxy?: string[] | undefined;
                }, {
                    noProxy?: string[] | undefined;
                }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"pac">;
                    proxyAutoconfigUrl: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"system">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "system";
                }, {
                    proxyType: "system";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
                unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                    alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                }, "strip", z.ZodTypeAny, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }>>>;
            }, "strip", z.ZodTypeAny, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        }, {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    }, {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    };
    method: "session.new";
}, {
    params: {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    };
    method: "session.new";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.status">;
    params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    params: Record<string, any>;
    method: "session.status";
}, {
    params: Record<string, any>;
    method: "session.status";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.subscribe">;
    params: z.ZodLazy<z.ZodObject<{
        events: z.ZodArray<z.ZodString, "many">;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        events: string[];
        contexts?: string[] | undefined;
    }, {
        events: string[];
        contexts?: string[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.subscribe";
}, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.subscribe";
}>>, z.ZodLazy<z.ZodObject<{
    method: z.ZodLiteral<"session.unsubscribe">;
    params: z.ZodLazy<z.ZodObject<{
        events: z.ZodArray<z.ZodString, "many">;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        events: string[];
        contexts?: string[] | undefined;
    }, {
        events: string[];
        contexts?: string[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.unsubscribe";
}, {
    params: {
        events: string[];
        contexts?: string[] | undefined;
    };
    method: "session.unsubscribe";
}>>]>>;
export declare namespace Session {
    const ProxyConfigurationSchema: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        proxyType: z.ZodLiteral<"autodetect">;
    }, "strip", z.ZodTypeAny, {
        proxyType: "autodetect";
    }, {
        proxyType: "autodetect";
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        proxyType: z.ZodLiteral<"direct">;
    }, "strip", z.ZodTypeAny, {
        proxyType: "direct";
    }, {
        proxyType: "direct";
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
        proxyType: z.ZodLiteral<"manual">;
        ftpProxy: z.ZodOptional<z.ZodString>;
        httpProxy: z.ZodOptional<z.ZodString>;
        sslProxy: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        proxyType: "manual";
        httpProxy?: string | undefined;
        ftpProxy?: string | undefined;
        sslProxy?: string | undefined;
    }, {
        proxyType: "manual";
        httpProxy?: string | undefined;
        ftpProxy?: string | undefined;
        sslProxy?: string | undefined;
    }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        socksProxy: z.ZodString;
        socksVersion: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        socksProxy: string;
        socksVersion: number;
    }, {
        socksProxy: string;
        socksVersion: number;
    }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
        noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        noProxy?: string[] | undefined;
    }, {
        noProxy?: string[] | undefined;
    }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        proxyType: z.ZodLiteral<"pac">;
        proxyAutoconfigUrl: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        proxyType: "pac";
        proxyAutoconfigUrl: string;
    }, {
        proxyType: "pac";
        proxyAutoconfigUrl: string;
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        proxyType: z.ZodLiteral<"system">;
    }, "strip", z.ZodTypeAny, {
        proxyType: "system";
    }, {
        proxyType: "system";
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>;
}
export declare const SessionResultSchema: z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodObject<{
    sessionId: z.ZodString;
    capabilities: z.ZodIntersection<z.ZodObject<{
        acceptInsecureCerts: z.ZodBoolean;
        browserName: z.ZodString;
        browserVersion: z.ZodString;
        platformName: z.ZodString;
        setWindowRect: z.ZodBoolean;
        userAgent: z.ZodString;
        proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"autodetect">;
        }, "strip", z.ZodTypeAny, {
            proxyType: "autodetect";
        }, {
            proxyType: "autodetect";
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"direct">;
        }, "strip", z.ZodTypeAny, {
            proxyType: "direct";
        }, {
            proxyType: "direct";
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"manual">;
            ftpProxy: z.ZodOptional<z.ZodString>;
            httpProxy: z.ZodOptional<z.ZodString>;
            sslProxy: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        }, {
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            socksProxy: z.ZodString;
            socksVersion: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            socksProxy: string;
            socksVersion: number;
        }, {
            socksProxy: string;
            socksVersion: number;
        }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
            noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            noProxy?: string[] | undefined;
        }, {
            noProxy?: string[] | undefined;
        }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"pac">;
            proxyAutoconfigUrl: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        }, {
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"system">;
        }, "strip", z.ZodTypeAny, {
            proxyType: "system";
        }, {
            proxyType: "system";
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
        unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
        }, "strip", z.ZodTypeAny, {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        }, {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        }>>>;
        webSocketUrl: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        acceptInsecureCerts: boolean;
        browserName: string;
        browserVersion: string;
        platformName: string;
        setWindowRect: boolean;
        userAgent: string;
        proxy?: ({
            proxyType: "autodetect";
        } & Record<string, any>) | ({
            proxyType: "direct";
        } & Record<string, any>) | ((({
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        } & ({
            socksProxy: string;
            socksVersion: number;
        } | {})) & {
            noProxy?: string[] | undefined;
        }) & Record<string, any>) | ({
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        } & Record<string, any>) | ({
            proxyType: "system";
        } & Record<string, any>) | {} | undefined;
        unhandledPromptBehavior?: {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        } | undefined;
        webSocketUrl?: string | undefined;
    }, {
        acceptInsecureCerts: boolean;
        browserName: string;
        browserVersion: string;
        platformName: string;
        setWindowRect: boolean;
        userAgent: string;
        proxy?: ({
            proxyType: "autodetect";
        } & Record<string, any>) | ({
            proxyType: "direct";
        } & Record<string, any>) | ((({
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        } & ({
            socksProxy: string;
            socksVersion: number;
        } | {})) & {
            noProxy?: string[] | undefined;
        }) & Record<string, any>) | ({
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        } & Record<string, any>) | ({
            proxyType: "system";
        } & Record<string, any>) | {} | undefined;
        unhandledPromptBehavior?: {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        } | undefined;
        webSocketUrl?: string | undefined;
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
}, "strip", z.ZodTypeAny, {
    capabilities: {
        acceptInsecureCerts: boolean;
        browserName: string;
        browserVersion: string;
        platformName: string;
        setWindowRect: boolean;
        userAgent: string;
        proxy?: ({
            proxyType: "autodetect";
        } & Record<string, any>) | ({
            proxyType: "direct";
        } & Record<string, any>) | ((({
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        } & ({
            socksProxy: string;
            socksVersion: number;
        } | {})) & {
            noProxy?: string[] | undefined;
        }) & Record<string, any>) | ({
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        } & Record<string, any>) | ({
            proxyType: "system";
        } & Record<string, any>) | {} | undefined;
        unhandledPromptBehavior?: {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        } | undefined;
        webSocketUrl?: string | undefined;
    } & Record<string, any>;
    sessionId: string;
}, {
    capabilities: {
        acceptInsecureCerts: boolean;
        browserName: string;
        browserVersion: string;
        platformName: string;
        setWindowRect: boolean;
        userAgent: string;
        proxy?: ({
            proxyType: "autodetect";
        } & Record<string, any>) | ({
            proxyType: "direct";
        } & Record<string, any>) | ((({
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        } & ({
            socksProxy: string;
            socksVersion: number;
        } | {})) & {
            noProxy?: string[] | undefined;
        }) & Record<string, any>) | ({
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        } & Record<string, any>) | ({
            proxyType: "system";
        } & Record<string, any>) | {} | undefined;
        unhandledPromptBehavior?: {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        } | undefined;
        webSocketUrl?: string | undefined;
    } & Record<string, any>;
    sessionId: string;
}>>, z.ZodLazy<z.ZodObject<{
    ready: z.ZodBoolean;
    message: z.ZodString;
}, "strip", z.ZodTypeAny, {
    message: string;
    ready: boolean;
}, {
    message: string;
    ready: boolean;
}>>]>>;
export declare namespace Session {
    const CapabilitiesRequestSchema: z.ZodLazy<z.ZodObject<{
        alwaysMatch: z.ZodOptional<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
            browserName: z.ZodOptional<z.ZodString>;
            browserVersion: z.ZodOptional<z.ZodString>;
            platformName: z.ZodOptional<z.ZodString>;
            proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"autodetect">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "autodetect";
            }, {
                proxyType: "autodetect";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"direct">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "direct";
            }, {
                proxyType: "direct";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"manual">;
                ftpProxy: z.ZodOptional<z.ZodString>;
                httpProxy: z.ZodOptional<z.ZodString>;
                sslProxy: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            }, {
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                socksProxy: z.ZodString;
                socksVersion: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                socksProxy: string;
                socksVersion: number;
            }, {
                socksProxy: string;
                socksVersion: number;
            }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                noProxy?: string[] | undefined;
            }, {
                noProxy?: string[] | undefined;
            }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"pac">;
                proxyAutoconfigUrl: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            }, {
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"system">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "system";
            }, {
                proxyType: "system";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
            unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            }, "strip", z.ZodTypeAny, {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            }, {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            }>>>;
        }, "strip", z.ZodTypeAny, {
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            acceptInsecureCerts?: boolean | undefined;
            browserName?: string | undefined;
            browserVersion?: string | undefined;
            platformName?: string | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
        }, {
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            acceptInsecureCerts?: boolean | undefined;
            browserName?: string | undefined;
            browserVersion?: string | undefined;
            platformName?: string | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>>;
        firstMatch: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
            browserName: z.ZodOptional<z.ZodString>;
            browserVersion: z.ZodOptional<z.ZodString>;
            platformName: z.ZodOptional<z.ZodString>;
            proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"autodetect">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "autodetect";
            }, {
                proxyType: "autodetect";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"direct">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "direct";
            }, {
                proxyType: "direct";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"manual">;
                ftpProxy: z.ZodOptional<z.ZodString>;
                httpProxy: z.ZodOptional<z.ZodString>;
                sslProxy: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            }, {
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                socksProxy: z.ZodString;
                socksVersion: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                socksProxy: string;
                socksVersion: number;
            }, {
                socksProxy: string;
                socksVersion: number;
            }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                noProxy?: string[] | undefined;
            }, {
                noProxy?: string[] | undefined;
            }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"pac">;
                proxyAutoconfigUrl: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            }, {
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"system">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "system";
            }, {
                proxyType: "system";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
            unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            }, "strip", z.ZodTypeAny, {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            }, {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            }>>>;
        }, "strip", z.ZodTypeAny, {
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            acceptInsecureCerts?: boolean | undefined;
            browserName?: string | undefined;
            browserVersion?: string | undefined;
            platformName?: string | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
        }, {
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            acceptInsecureCerts?: boolean | undefined;
            browserName?: string | undefined;
            browserVersion?: string | undefined;
            platformName?: string | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">>;
    }, "strip", z.ZodTypeAny, {
        alwaysMatch?: ({
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            acceptInsecureCerts?: boolean | undefined;
            browserName?: string | undefined;
            browserVersion?: string | undefined;
            platformName?: string | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
        } & Record<string, any>) | undefined;
        firstMatch?: ({
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            acceptInsecureCerts?: boolean | undefined;
            browserName?: string | undefined;
            browserVersion?: string | undefined;
            platformName?: string | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
        } & Record<string, any>)[] | undefined;
    }, {
        alwaysMatch?: ({
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            acceptInsecureCerts?: boolean | undefined;
            browserName?: string | undefined;
            browserVersion?: string | undefined;
            platformName?: string | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
        } & Record<string, any>) | undefined;
        firstMatch?: ({
            proxy?: ({
                proxyType: "autodetect";
            } & Record<string, any>) | ({
                proxyType: "direct";
            } & Record<string, any>) | ((({
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            } & ({
                socksProxy: string;
                socksVersion: number;
            } | {})) & {
                noProxy?: string[] | undefined;
            }) & Record<string, any>) | ({
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            } & Record<string, any>) | ({
                proxyType: "system";
            } & Record<string, any>) | {} | undefined;
            acceptInsecureCerts?: boolean | undefined;
            browserName?: string | undefined;
            browserVersion?: string | undefined;
            platformName?: string | undefined;
            unhandledPromptBehavior?: {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            } | undefined;
        } & Record<string, any>)[] | undefined;
    }>>;
}
export declare namespace Session {
    const CapabilityRequestSchema: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
        browserName: z.ZodOptional<z.ZodString>;
        browserVersion: z.ZodOptional<z.ZodString>;
        platformName: z.ZodOptional<z.ZodString>;
        proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"autodetect">;
        }, "strip", z.ZodTypeAny, {
            proxyType: "autodetect";
        }, {
            proxyType: "autodetect";
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"direct">;
        }, "strip", z.ZodTypeAny, {
            proxyType: "direct";
        }, {
            proxyType: "direct";
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"manual">;
            ftpProxy: z.ZodOptional<z.ZodString>;
            httpProxy: z.ZodOptional<z.ZodString>;
            sslProxy: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        }, {
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
            socksProxy: z.ZodString;
            socksVersion: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            socksProxy: string;
            socksVersion: number;
        }, {
            socksProxy: string;
            socksVersion: number;
        }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
            noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            noProxy?: string[] | undefined;
        }, {
            noProxy?: string[] | undefined;
        }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"pac">;
            proxyAutoconfigUrl: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        }, {
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
            proxyType: z.ZodLiteral<"system">;
        }, "strip", z.ZodTypeAny, {
            proxyType: "system";
        }, {
            proxyType: "system";
        }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
        unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
            alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
        }, "strip", z.ZodTypeAny, {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        }, {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        proxy?: ({
            proxyType: "autodetect";
        } & Record<string, any>) | ({
            proxyType: "direct";
        } & Record<string, any>) | ((({
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        } & ({
            socksProxy: string;
            socksVersion: number;
        } | {})) & {
            noProxy?: string[] | undefined;
        }) & Record<string, any>) | ({
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        } & Record<string, any>) | ({
            proxyType: "system";
        } & Record<string, any>) | {} | undefined;
        acceptInsecureCerts?: boolean | undefined;
        browserName?: string | undefined;
        browserVersion?: string | undefined;
        platformName?: string | undefined;
        unhandledPromptBehavior?: {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        } | undefined;
    }, {
        proxy?: ({
            proxyType: "autodetect";
        } & Record<string, any>) | ({
            proxyType: "direct";
        } & Record<string, any>) | ((({
            proxyType: "manual";
            httpProxy?: string | undefined;
            ftpProxy?: string | undefined;
            sslProxy?: string | undefined;
        } & ({
            socksProxy: string;
            socksVersion: number;
        } | {})) & {
            noProxy?: string[] | undefined;
        }) & Record<string, any>) | ({
            proxyType: "pac";
            proxyAutoconfigUrl: string;
        } & Record<string, any>) | ({
            proxyType: "system";
        } & Record<string, any>) | {} | undefined;
        acceptInsecureCerts?: boolean | undefined;
        browserName?: string | undefined;
        browserVersion?: string | undefined;
        platformName?: string | undefined;
        unhandledPromptBehavior?: {
            default?: "accept" | "dismiss" | "ignore" | undefined;
            prompt?: "accept" | "dismiss" | "ignore" | undefined;
            alert?: "accept" | "dismiss" | "ignore" | undefined;
            confirm?: "accept" | "dismiss" | "ignore" | undefined;
            beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
        } | undefined;
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
}
export declare namespace Session {
    const AutodetectProxyConfigurationSchema: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        proxyType: z.ZodLiteral<"autodetect">;
    }, "strip", z.ZodTypeAny, {
        proxyType: "autodetect";
    }, {
        proxyType: "autodetect";
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
}
export declare namespace Session {
    const DirectProxyConfigurationSchema: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        proxyType: z.ZodLiteral<"direct">;
    }, "strip", z.ZodTypeAny, {
        proxyType: "direct";
    }, {
        proxyType: "direct";
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
}
export declare namespace Session {
    const ManualProxyConfigurationSchema: z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
        proxyType: z.ZodLiteral<"manual">;
        ftpProxy: z.ZodOptional<z.ZodString>;
        httpProxy: z.ZodOptional<z.ZodString>;
        sslProxy: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        proxyType: "manual";
        httpProxy?: string | undefined;
        ftpProxy?: string | undefined;
        sslProxy?: string | undefined;
    }, {
        proxyType: "manual";
        httpProxy?: string | undefined;
        ftpProxy?: string | undefined;
        sslProxy?: string | undefined;
    }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
        socksProxy: z.ZodString;
        socksVersion: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        socksProxy: string;
        socksVersion: number;
    }, {
        socksProxy: string;
        socksVersion: number;
    }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
        noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        noProxy?: string[] | undefined;
    }, {
        noProxy?: string[] | undefined;
    }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
}
export declare namespace Session {
    const SocksProxyConfigurationSchema: z.ZodLazy<z.ZodObject<{
        socksProxy: z.ZodString;
        socksVersion: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        socksProxy: string;
        socksVersion: number;
    }, {
        socksProxy: string;
        socksVersion: number;
    }>>;
}
export declare namespace Session {
    const PacProxyConfigurationSchema: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        proxyType: z.ZodLiteral<"pac">;
        proxyAutoconfigUrl: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        proxyType: "pac";
        proxyAutoconfigUrl: string;
    }, {
        proxyType: "pac";
        proxyAutoconfigUrl: string;
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
}
export declare namespace Session {
    const SystemProxyConfigurationSchema: z.ZodLazy<z.ZodIntersection<z.ZodObject<{
        proxyType: z.ZodLiteral<"system">;
    }, "strip", z.ZodTypeAny, {
        proxyType: "system";
    }, {
        proxyType: "system";
    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>;
}
export declare namespace Session {
    const UserPromptHandlerSchema: z.ZodLazy<z.ZodObject<{
        alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
        beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
        confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
        default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
        prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
    }, "strip", z.ZodTypeAny, {
        default?: "accept" | "dismiss" | "ignore" | undefined;
        prompt?: "accept" | "dismiss" | "ignore" | undefined;
        alert?: "accept" | "dismiss" | "ignore" | undefined;
        confirm?: "accept" | "dismiss" | "ignore" | undefined;
        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
    }, {
        default?: "accept" | "dismiss" | "ignore" | undefined;
        prompt?: "accept" | "dismiss" | "ignore" | undefined;
        alert?: "accept" | "dismiss" | "ignore" | undefined;
        confirm?: "accept" | "dismiss" | "ignore" | undefined;
        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
    }>>;
}
export declare namespace Session {
    const UserPromptHandlerTypeSchema: z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>;
}
export declare namespace Session {
    const SubscriptionRequestSchema: z.ZodLazy<z.ZodObject<{
        events: z.ZodArray<z.ZodString, "many">;
        contexts: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodString>, "many">>;
    }, "strip", z.ZodTypeAny, {
        events: string[];
        contexts?: string[] | undefined;
    }, {
        events: string[];
        contexts?: string[] | undefined;
    }>>;
}
export declare namespace Session {
    const StatusSchema: z.ZodLazy<z.ZodObject<{
        method: z.ZodLiteral<"session.status">;
        params: z.ZodLazy<z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>;
    }, "strip", z.ZodTypeAny, {
        params: Record<string, any>;
        method: "session.status";
    }, {
        params: Record<string, any>;
        method: "session.status";
    }>>;
}
export declare namespace Session {
    const StatusResultSchema: z.ZodLazy<z.ZodObject<{
        ready: z.ZodBoolean;
        message: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        message: string;
        ready: boolean;
    }, {
        message: string;
        ready: boolean;
    }>>;
}
export declare namespace Session {
    const NewSchema: z.ZodLazy<z.ZodObject<{
        method: z.ZodLiteral<"session.new">;
        params: z.ZodLazy<z.ZodObject<{
            capabilities: z.ZodLazy<z.ZodObject<{
                alwaysMatch: z.ZodOptional<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
                    browserName: z.ZodOptional<z.ZodString>;
                    browserVersion: z.ZodOptional<z.ZodString>;
                    platformName: z.ZodOptional<z.ZodString>;
                    proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        proxyType: z.ZodLiteral<"autodetect">;
                    }, "strip", z.ZodTypeAny, {
                        proxyType: "autodetect";
                    }, {
                        proxyType: "autodetect";
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        proxyType: z.ZodLiteral<"direct">;
                    }, "strip", z.ZodTypeAny, {
                        proxyType: "direct";
                    }, {
                        proxyType: "direct";
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                        proxyType: z.ZodLiteral<"manual">;
                        ftpProxy: z.ZodOptional<z.ZodString>;
                        httpProxy: z.ZodOptional<z.ZodString>;
                        sslProxy: z.ZodOptional<z.ZodString>;
                    }, "strip", z.ZodTypeAny, {
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    }, {
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                        socksProxy: z.ZodString;
                        socksVersion: z.ZodNumber;
                    }, "strip", z.ZodTypeAny, {
                        socksProxy: string;
                        socksVersion: number;
                    }, {
                        socksProxy: string;
                        socksVersion: number;
                    }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                        noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                    }, "strip", z.ZodTypeAny, {
                        noProxy?: string[] | undefined;
                    }, {
                        noProxy?: string[] | undefined;
                    }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        proxyType: z.ZodLiteral<"pac">;
                        proxyAutoconfigUrl: z.ZodString;
                    }, "strip", z.ZodTypeAny, {
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    }, {
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        proxyType: z.ZodLiteral<"system">;
                    }, "strip", z.ZodTypeAny, {
                        proxyType: "system";
                    }, {
                        proxyType: "system";
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
                    unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                        alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                        beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                        confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                        default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                        prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    }, "strip", z.ZodTypeAny, {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    }, {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    }>>>;
                }, "strip", z.ZodTypeAny, {
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                }, {
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>>;
                firstMatch: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
                    browserName: z.ZodOptional<z.ZodString>;
                    browserVersion: z.ZodOptional<z.ZodString>;
                    platformName: z.ZodOptional<z.ZodString>;
                    proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        proxyType: z.ZodLiteral<"autodetect">;
                    }, "strip", z.ZodTypeAny, {
                        proxyType: "autodetect";
                    }, {
                        proxyType: "autodetect";
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        proxyType: z.ZodLiteral<"direct">;
                    }, "strip", z.ZodTypeAny, {
                        proxyType: "direct";
                    }, {
                        proxyType: "direct";
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                        proxyType: z.ZodLiteral<"manual">;
                        ftpProxy: z.ZodOptional<z.ZodString>;
                        httpProxy: z.ZodOptional<z.ZodString>;
                        sslProxy: z.ZodOptional<z.ZodString>;
                    }, "strip", z.ZodTypeAny, {
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    }, {
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                        socksProxy: z.ZodString;
                        socksVersion: z.ZodNumber;
                    }, "strip", z.ZodTypeAny, {
                        socksProxy: string;
                        socksVersion: number;
                    }, {
                        socksProxy: string;
                        socksVersion: number;
                    }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                        noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                    }, "strip", z.ZodTypeAny, {
                        noProxy?: string[] | undefined;
                    }, {
                        noProxy?: string[] | undefined;
                    }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        proxyType: z.ZodLiteral<"pac">;
                        proxyAutoconfigUrl: z.ZodString;
                    }, "strip", z.ZodTypeAny, {
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    }, {
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                        proxyType: z.ZodLiteral<"system">;
                    }, "strip", z.ZodTypeAny, {
                        proxyType: "system";
                    }, {
                        proxyType: "system";
                    }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
                    unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                        alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                        beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                        confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                        default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                        prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    }, "strip", z.ZodTypeAny, {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    }, {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    }>>>;
                }, "strip", z.ZodTypeAny, {
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                }, {
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">>;
            }, "strip", z.ZodTypeAny, {
                alwaysMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>) | undefined;
                firstMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>)[] | undefined;
            }, {
                alwaysMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>) | undefined;
                firstMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>)[] | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            capabilities: {
                alwaysMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>) | undefined;
                firstMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>)[] | undefined;
            };
        }, {
            capabilities: {
                alwaysMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>) | undefined;
                firstMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>)[] | undefined;
            };
        }>>;
    }, "strip", z.ZodTypeAny, {
        params: {
            capabilities: {
                alwaysMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>) | undefined;
                firstMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>)[] | undefined;
            };
        };
        method: "session.new";
    }, {
        params: {
            capabilities: {
                alwaysMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>) | undefined;
                firstMatch?: ({
                    proxy?: ({
                        proxyType: "autodetect";
                    } & Record<string, any>) | ({
                        proxyType: "direct";
                    } & Record<string, any>) | ((({
                        proxyType: "manual";
                        httpProxy?: string | undefined;
                        ftpProxy?: string | undefined;
                        sslProxy?: string | undefined;
                    } & ({
                        socksProxy: string;
                        socksVersion: number;
                    } | {})) & {
                        noProxy?: string[] | undefined;
                    }) & Record<string, any>) | ({
                        proxyType: "pac";
                        proxyAutoconfigUrl: string;
                    } & Record<string, any>) | ({
                        proxyType: "system";
                    } & Record<string, any>) | {} | undefined;
                    acceptInsecureCerts?: boolean | undefined;
                    browserName?: string | undefined;
                    browserVersion?: string | undefined;
                    platformName?: string | undefined;
                    unhandledPromptBehavior?: {
                        default?: "accept" | "dismiss" | "ignore" | undefined;
                        prompt?: "accept" | "dismiss" | "ignore" | undefined;
                        alert?: "accept" | "dismiss" | "ignore" | undefined;
                        confirm?: "accept" | "dismiss" | "ignore" | undefined;
                        beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                    } | undefined;
                } & Record<string, any>)[] | undefined;
            };
        };
        method: "session.new";
    }>>;
}
export declare namespace Session {
    const NewParametersSchema: z.ZodLazy<z.ZodObject<{
        capabilities: z.ZodLazy<z.ZodObject<{
            alwaysMatch: z.ZodOptional<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
                browserName: z.ZodOptional<z.ZodString>;
                browserVersion: z.ZodOptional<z.ZodString>;
                platformName: z.ZodOptional<z.ZodString>;
                proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"autodetect">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "autodetect";
                }, {
                    proxyType: "autodetect";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"direct">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "direct";
                }, {
                    proxyType: "direct";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"manual">;
                    ftpProxy: z.ZodOptional<z.ZodString>;
                    httpProxy: z.ZodOptional<z.ZodString>;
                    sslProxy: z.ZodOptional<z.ZodString>;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    socksProxy: z.ZodString;
                    socksVersion: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    socksProxy: string;
                    socksVersion: number;
                }, {
                    socksProxy: string;
                    socksVersion: number;
                }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                    noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                }, "strip", z.ZodTypeAny, {
                    noProxy?: string[] | undefined;
                }, {
                    noProxy?: string[] | undefined;
                }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"pac">;
                    proxyAutoconfigUrl: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"system">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "system";
                }, {
                    proxyType: "system";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
                unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                    alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                }, "strip", z.ZodTypeAny, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }>>>;
            }, "strip", z.ZodTypeAny, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>>;
            firstMatch: z.ZodOptional<z.ZodArray<z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                acceptInsecureCerts: z.ZodOptional<z.ZodBoolean>;
                browserName: z.ZodOptional<z.ZodString>;
                browserVersion: z.ZodOptional<z.ZodString>;
                platformName: z.ZodOptional<z.ZodString>;
                proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"autodetect">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "autodetect";
                }, {
                    proxyType: "autodetect";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"direct">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "direct";
                }, {
                    proxyType: "direct";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"manual">;
                    ftpProxy: z.ZodOptional<z.ZodString>;
                    httpProxy: z.ZodOptional<z.ZodString>;
                    sslProxy: z.ZodOptional<z.ZodString>;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }, {
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                    socksProxy: z.ZodString;
                    socksVersion: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    socksProxy: string;
                    socksVersion: number;
                }, {
                    socksProxy: string;
                    socksVersion: number;
                }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                    noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                }, "strip", z.ZodTypeAny, {
                    noProxy?: string[] | undefined;
                }, {
                    noProxy?: string[] | undefined;
                }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"pac">;
                    proxyAutoconfigUrl: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }, {
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                    proxyType: z.ZodLiteral<"system">;
                }, "strip", z.ZodTypeAny, {
                    proxyType: "system";
                }, {
                    proxyType: "system";
                }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
                unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                    alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                    prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                }, "strip", z.ZodTypeAny, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }, {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                }>>>;
            }, "strip", z.ZodTypeAny, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }, {
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, "many">>;
        }, "strip", z.ZodTypeAny, {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        }, {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    }, {
        capabilities: {
            alwaysMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>) | undefined;
            firstMatch?: ({
                proxy?: ({
                    proxyType: "autodetect";
                } & Record<string, any>) | ({
                    proxyType: "direct";
                } & Record<string, any>) | ((({
                    proxyType: "manual";
                    httpProxy?: string | undefined;
                    ftpProxy?: string | undefined;
                    sslProxy?: string | undefined;
                } & ({
                    socksProxy: string;
                    socksVersion: number;
                } | {})) & {
                    noProxy?: string[] | undefined;
                }) & Record<string, any>) | ({
                    proxyType: "pac";
                    proxyAutoconfigUrl: string;
                } & Record<string, any>) | ({
                    proxyType: "system";
                } & Record<string, any>) | {} | undefined;
                acceptInsecureCerts?: boolean | undefined;
                browserName?: string | undefined;
                browserVersion?: string | undefined;
                platformName?: string | undefined;
                unhandledPromptBehavior?: {
                    default?: "accept" | "dismiss" | "ignore" | undefined;
                    prompt?: "accept" | "dismiss" | "ignore" | undefined;
                    alert?: "accept" | "dismiss" | "ignore" | undefined;
                    confirm?: "accept" | "dismiss" | "ignore" | undefined;
                    beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
                } | undefined;
            } & Record<string, any>)[] | undefined;
        };
    }>>;
}
export declare namespace Session {
    const NewResultSchema: z.ZodLazy<z.ZodObject<{
        sessionId: z.ZodString;
        capabilities: z.ZodIntersection<z.ZodObject<{
            acceptInsecureCerts: z.ZodBoolean;
            browserName: z.ZodString;
            browserVersion: z.ZodString;
            platformName: z.ZodString;
            setWindowRect: z.ZodBoolean;
            userAgent: z.ZodString;
            proxy: z.ZodOptional<z.ZodLazy<z.ZodUnion<[z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"autodetect">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "autodetect";
            }, {
                proxyType: "autodetect";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"direct">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "direct";
            }, {
                proxyType: "direct";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"manual">;
                ftpProxy: z.ZodOptional<z.ZodString>;
                httpProxy: z.ZodOptional<z.ZodString>;
                sslProxy: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            }, {
                proxyType: "manual";
                httpProxy?: string | undefined;
                ftpProxy?: string | undefined;
                sslProxy?: string | undefined;
            }>, z.ZodUnion<[z.ZodLazy<z.ZodObject<{
                socksProxy: z.ZodString;
                socksVersion: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                socksProxy: string;
                socksVersion: number;
            }, {
                socksProxy: string;
                socksVersion: number;
            }>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>, z.ZodObject<{
                noProxy: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                noProxy?: string[] | undefined;
            }, {
                noProxy?: string[] | undefined;
            }>>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"pac">;
                proxyAutoconfigUrl: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            }, {
                proxyType: "pac";
                proxyAutoconfigUrl: string;
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodLazy<z.ZodIntersection<z.ZodObject<{
                proxyType: z.ZodLiteral<"system">;
            }, "strip", z.ZodTypeAny, {
                proxyType: "system";
            }, {
                proxyType: "system";
            }>, z.ZodLazy<z.ZodRecord<z.ZodString, z.ZodAny>>>>, z.ZodObject<{}, "strip", z.ZodTypeAny, {}, {}>]>>>;
            unhandledPromptBehavior: z.ZodOptional<z.ZodLazy<z.ZodObject<{
                alert: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                beforeUnload: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                confirm: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                default: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
                prompt: z.ZodOptional<z.ZodLazy<z.ZodEnum<["accept", "dismiss", "ignore"]>>>;
            }, "strip", z.ZodTypeAny, {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            }, {
                default?: "accept" | "dismiss" | "ignore" | undefined;
                prompt?: "accept" | "dismiss" | "ignore" | undefined;
                alert?: "accept" | "dismiss" | "ignore" | undefined;
                confirm?: "accept" | "dismiss" | "ignore" | undefined;
                beforeUnload?: "accept" | "dismiss" | "ignore" | undefined;
            }>>>;
            webSocketUrl: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            acceptInsecureCerts: boolean;
            browserName: string;
            browserVersion: string;
            platformName: string;
            setWindowRect: boolean;
            userAgent: string;
            proxy?: ({
                proxyType: "autodetect";
