<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Paths and API details
$videoPath = __DIR__ . '/input_video.mp4';
$captionsJsonPath = __DIR__ . '/captions.json';
$whisperApiKey = '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'; // Replace with your test API key
$whisperApiUrl = 'https://api.openai.com/v1/audio/transcriptions';

// Step 1: Transcribe the video using Whisper API with word-level timestamps
function transcribeVideo($videoPath, $apiKey, $apiUrl) {
    if (!file_exists($videoPath)) {
        error_log("Error: Video file not found at path: " . $videoPath);
        die("Error: Video file not found.\n");
    }

    $curl = curl_init();
    $headers = [
        'Authorization: Bearer ' . $apiKey,
        'Content-Type: multipart/form-data'
    ];
    $postData = [
        'file' => new CURLFile($videoPath),
        'model' => 'whisper-1',
        'response_format' => 'verbose_json',
        'timestamp_granularities[]' => 'word' // Request word-level timestamps
    ];
    curl_setopt_array($curl, [
        CURLOPT_URL => $apiUrl,
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => $postData
    ]);
    $response = curl_exec($curl);
    if ($response === false) {
        $curlError = curl_error($curl);
        curl_close($curl);
        error_log("cURL Error: " . $curlError);
        die("Error: Failed to make API request. cURL Error: " . $curlError . "\n");
    }
    curl_close($curl);
    
    // Save the full API response for debugging
    file_put_contents(__DIR__ . '/whisper_api_response.json', $response);

    $result = json_decode($response, true);
    
    // Check if 'words' are present in the response
    if (!isset($result['words']) || !is_array($result['words'])) {
        error_log("No word-level timestamps found in the response.");
        return [];
    }

    return $result['words'];
}

// Step 2: Generate Captions JSON with Word-Level Timestamps
function generateCaptionsJson($words) {
    $captions = [];
    foreach ($words as $wordInfo) {
        if (isset($wordInfo['word'], $wordInfo['start'], $wordInfo['end'])) {
            $captions[] = [
                'text' => $wordInfo['word'],
                'startTime' => $wordInfo['start'],
                'endTime' => $wordInfo['end']
            ];
        }
    }
    return $captions;
}

// Step 3: Save Captions to captions.json
function saveCaptionsJson($captions, $outputPath) {
    $jsonContent = json_encode($captions, JSON_PRETTY_PRINT);
    if (file_put_contents($outputPath, $jsonContent) === false) {
        error_log("Error: Failed to save captions.json file.");
        die("Error: Failed to save captions.json file.\n");
    }
    echo "captions.json file saved successfully: {$outputPath}\n";
}

// Step 4: Render Video with Captions (using existing Puppeteer script)
function renderVideoWithCaptions() {
    $output = shell_exec('export DISPLAY=:99 && xvfb-run -a node record_video.js 2>&1');
    echo "Recording Output: " . $output . "\n";
}

// Execute the transcription process
$words = transcribeVideo($videoPath, $whisperApiKey, $whisperApiUrl);
$captions = generateCaptionsJson($words);
saveCaptionsJson($captions, $captionsJsonPath);

// Step 4: Render video with captions using Puppeteer
renderVideoWithCaptions();

echo "All steps completed successfully.\n";
?>
