<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Whisper API Details
// Whisper API Details
$whisperApiKey = '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'; // Replace with your actual API key
$whisperApiUrl = 'https://api.openai.com/v1/audio/transcriptions';

// Path to the video file
$videoPath = __DIR__ . '/input_video.mp4';

// Step 1: Send the Video to Whisper AI API for Transcription
function transcribeVideo($videoPath, $apiKey, $apiUrl) {
    echo "Uploading video for transcription...\n";

    if (!file_exists($videoPath)) {
        error_log("Error: Video file not found at path: " . $videoPath);
        die("Error: Video file not found.\n");
    }

    $curl = curl_init();

    $headers = [
        'Authorization: Bearer ' . $apiKey,
        'Content-Type: multipart/form-data'
    ];

    $postData = [
        'file' => new CURLFile($videoPath),
        'model' => 'whisper-1',
        'response_format' => 'verbose_json'
    ];

    curl_setopt_array($curl, [
        CURLOPT_URL => $apiUrl,
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => $postData
    ]);

    $response = curl_exec($curl);

    if ($response === false) {
        $curlError = curl_error($curl);
        curl_close($curl);
        error_log("cURL Error: " . $curlError);
        die("Error: Failed to make API request. cURL Error: " . $curlError . "\n");
    }

    curl_close($curl);

    echo "Whisper API raw response: " . $response . "\n";
    error_log("Whisper API response: " . $response);

    $result = json_decode($response, true);

    if (isset($result['error'])) {
        error_log("API Error: " . $result['error']['message']);
        die("Error: " . $result['error']['message'] . "\n");
    }

    if (!isset($result['segments']) || !is_array($result['segments'])) {
        error_log("Error: No segments found in response.");
        echo "Error: No segments found in response.\n";
        return []; // Return an empty array instead of NULL
    }

    echo "Video transcribed successfully.\n";
    return $result['segments']; // Return the segments array
}

// Step 2: Process the Segments Result
function processTranscription($segments) {
    echo "Processing transcription to create SRT captions...\n";
    $srtContent = '';
    $index = 1;

    foreach ($segments as $segment) {
        $start = formatTimestamp($segment['start']);
        $end = formatTimestamp($segment['end']);
        $text = $segment['text'];

        $srtContent .= "{$index}\n";
        $srtContent .= "{$start} --> {$end}\n";
        $srtContent .= trim($text) . "\n\n";
        $index++;
    }

    return $srtContent;
}

// Step 3: Format timestamp for SRT
function formatTimestamp($seconds) {
    $hours = (int) floor($seconds / 3600);
    $minutes = (int) floor(($seconds % 3600) / 60);
    $secondsPart = (int) floor($seconds % 60);
    $milliseconds = (int) round(($seconds - floor($seconds)) * 1000);

    return sprintf('%02d:%02d:%02d,%03d', $hours, $minutes, $secondsPart, $milliseconds);
}

// Step 4: Save the SRT content to a file
function saveSRT($srtContent, $outputPath) {
    if (file_put_contents($outputPath, $srtContent) === false) {
        error_log("Error: Failed to save SRT file.");
        die("Error: Failed to save SRT file.\n");
    }
    echo "SRT file saved successfully: {$outputPath}\n";
}

// Step 5: Burn Captions into Video using ffmpeg
function burnCaptionsIntoVideo($videoPath, $srtPath, $outputVideoPath) {
    echo "Embedding captions into video using ffmpeg...\n";

    // Check if ffmpeg is available
    $ffmpegCheck = shell_exec("which ffmpeg");
    if (empty($ffmpegCheck)) {
        die("Error: ffmpeg is not installed or not available in the system PATH.\n");
    }

    // Command to burn captions into the video
    $cmd = "ffmpeg -y -i " . escapeshellarg($videoPath) . " -vf subtitles=" . escapeshellarg($srtPath) . " " . escapeshellarg($outputVideoPath) . " 2>&1";
    echo "Executing command: $cmd\n";

    $output = shell_exec($cmd);

    echo "ffmpeg output: \n$output\n";

    // Check if the output video file was created
    if (!file_exists($outputVideoPath)) {
        die("Error: Failed to create the video with embedded captions.\n");
    }

    echo "Video with captions saved successfully: {$outputVideoPath}\n";
}

// Execute the transcription process
$segments = transcribeVideo($videoPath, $whisperApiKey, $whisperApiUrl);

if (!empty($segments)) {
    $srtContent = processTranscription($segments);
    $srtPath = __DIR__ . '/transcription.srt';
    saveSRT($srtContent, $srtPath);

    // Path for the output video
    $outputVideoPath = __DIR__ . '/output_video.mp4';

    // Burn captions into the video
    burnCaptionsIntoVideo($videoPath, $srtPath, $outputVideoPath);
}

echo "All steps completed successfully.\n";
?>
