<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Whisper API Details
$whisperApiKey = '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'; // Replace with your actual API key
$whisperApiUrl = 'https://api.openai.com/v1/audio/transcriptions';

// Path to the video file
$videoPath = __DIR__ . '/input_video.mp4';

// Step 1: Send the Video to Whisper AI API for Transcription
function transcribeVideo($videoPath, $apiKey, $apiUrl) {
    echo "Uploading video for transcription...\n";

    if (!file_exists($videoPath)) {
        error_log("Error: Video file not found at path: " . $videoPath);
        die("Error: Video file not found.\n");
    }

    $ch = curl_init();

    $headers = [
        'Authorization: Bearer ' . $apiKey
    ];

    $postData = [
        'file' => new CURLFile($videoPath),
        'model' => 'whisper-1',
        'response_format' => 'verbose_json'
    ];

    curl_setopt_array($ch, [
        CURLOPT_URL => $apiUrl,
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => $postData
    ]);

    $response = curl_exec($ch);

    if ($response === false) {
        $curlError = curl_error($ch);
        curl_close($ch);
        error_log("cURL Error: " . $curlError);
        die("Error: Failed to make API request. cURL Error: " . $curlError . "\n");
    }

    curl_close($ch);

    echo "Whisper API response received.\n";

    $result = json_decode($response, true);

    if (isset($result['error'])) {
        error_log("API Error: " . $result['error']['message']);
        die("Error: " . $result['error']['message'] . "\n");
    }

    // Save the transcription data to a JSON file
    $transcriptionPath = __DIR__ . '/transcription.json';
    file_put_contents($transcriptionPath, json_encode($result, JSON_PRETTY_PRINT));
    echo "Transcription data saved to transcription.json\n";

    return $result;
}

// Execute the transcription process
$transcriptionData = transcribeVideo($videoPath, $whisperApiKey, $whisperApiUrl);
?>
