<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if Node.js and Puppeteer are installed
$nodeCheck = shell_exec("which node");
if (empty($nodeCheck)) {
    die("Error: Node.js is not installed or not available in the system PATH.\n");
}

// Install necessary Node.js packages if not already installed
if (!file_exists('node_modules')) {
    echo "Installing Node.js dependencies...\n";
    exec('npm install puppeteer fluent-ffmpeg', $output, $return_var);
    if ($return_var !== 0) {
        die("Error: Failed to install Node.js dependencies.\n");
    }
}

// Run the recording script
echo "Starting video recording...\n";
exec('node record_video.js', $output, $return_var);
if ($return_var !== 0) {
    die("Error: Failed to record video.\n");
}
echo "Video recording completed successfully.\n";
?>
