<?php
// Database connection
$servername = "localhost";
$username = "correllvps_admin";
$password = "Iwant$100";
$dbname = "correllvps_production";

$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the 'id' from the URL (e.g., captionview.php?id=1)
$id = isset($_GET['id']) ? intval($_GET['id']) : 0; // Default to 0 if 'id' is not set

// Fetch template variables for the specific 'id'
$sql = "SELECT * FROM caption_templates WHERE id = '$id'";
$result = $conn->query($sql);

$templateVars = [];

if ($result->num_rows > 0) {
    $templateVars = $result->fetch_assoc();
} else {
    die("Template not found");
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Video with Captions</title>
    <style>
        /* Pre-load fonts using @font-face */
        <?php if (!empty($templateVars['fontFamily'])): ?>
        @font-face {
            font-family: '<?php echo $templateVars['fontFamily']; ?>';
            src: url('fonts/<?php echo $templateVars['fontFamily']; ?>.ttf') format('truetype'),
                 url('fonts/<?php echo $templateVars['fontFamily']; ?>.otf') format('opentype');
        }
        <?php endif; ?>
        
        <?php if (!empty($templateVars['emojiFontFamily'])): ?>
        @font-face {
            font-family: '<?php echo $templateVars['emojiFontFamily']; ?>';
            src: url('fonts/<?php echo $templateVars['emojiFontFamily']; ?>.ttf') format('truetype'),
                 url('fonts/<?php echo $templateVars['emojiFontFamily']; ?>.otf') format('opentype');
        }
        <?php endif; ?>

        /* Base styling for all text elements */
        text, tspan {
            font-family: '<?php echo $templateVars['fontFamily'] ?? 'Arial'; ?>', sans-serif;
            fill: <?php echo $templateVars['fontColor'] ?? '#ffffff'; ?>;
            stroke: <?php echo $templateVars['strokeColor'] ?? '#000000'; ?>;
            stroke-width: <?php echo $templateVars['strokeWidth'] ?? '6px'; ?>;
            paint-order: stroke;
            font-size: <?php echo $templateVars['fontSize'] ?? '36px'; ?>;
            transition: transform 0.2s ease, fill 0.2s ease;
            <?php if ($templateVars['textAllCaps'] === 'Yes'): ?>
            text-transform: uppercase;
            <?php endif; ?>
        }

        /* Video container styling */
        body, html {
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            overflow: hidden;
            background-color: <?php echo $templateVars['backgroundColor'] ?? 'black'; ?>;
        }

        #video-container {
            position: relative;
            width: 100vw;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: <?php echo $templateVars['backgroundColor'] ?? 'black'; ?>;
        }

        video {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }

        svg {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
        }

        /* Style for emojis */
        .emoji {
            transform-origin: center;
            transform: scale(<?php echo $templateVars['emojiFontSize'] / 36 ?? 2; ?>); /* Scale relative to default size */
            font-family: '<?php echo $templateVars['emojiFontFamily'] ?? 'NotoColorEmoji'; ?>', Arial, sans-serif;
        }

        /* Highlight effect for the current word */
        .highlight {
            fill: <?php echo $templateVars['highlightColor'] ?? '#00ff00'; ?>;
            transform: scale(<?php echo $templateVars['highlightAnimation'] ?? '1.2'; ?>);
            transition: transform 0.2s ease, fill 0.2s ease;
        }
    </style>
</head>
<body>
    <div id="video-container">
        <video id="video" src="input_video.mp4" autoplay muted></video>
        <svg id="svg-captions"></svg>
        <?php if ($templateVars['show_emojis'] === 'Yes') { ?>
            <svg id="svg-emoji"></svg> <!-- Only include this if show_emojis is set to "Yes" -->
        <?php } ?>
    </div>
    <script src="captions.js"></script>
    <script>
        let emojiData;
        const showEmojis = '<?php echo $templateVars['show_emojis'] ?? 'Yes'; ?>';
        const emojiY = '<?php echo $templateVars['emojiY'] ?? '50%'; ?>';
        const captionY = '<?php echo $templateVars['captionY'] ?? '80%'; ?>';
        const textAllCaps = '<?php echo $templateVars['textAllCaps'] ?? 'No'; ?>';

        // Load the emoji JSON file only if show_emojis is "Yes"
        if (showEmojis === 'Yes') {
            fetch('emoji-en-US.json')
                .then(response => response.json())
                .then(data => {
                    emojiData = data;
                    loadCaptions();
                })
                .catch(error => console.error('Error loading emoji JSON:', error));
        } else {
            loadCaptions(); // Load captions even if emojis are not shown
        }

        function loadCaptions() {
            fetch('captions.json')
                .then(response => response.json())
                .then(captionsData => {
                    startCaptionsDisplay(captionsData);
                    if (showEmojis === 'Yes') {
                        fetch('emoji_captions.json')
                            .then(response => response.json())
                            .then(emojiCaptionsData => {
                                startEmojiDisplay(emojiCaptionsData);
                            })
                            .catch(error => console.error('Error loading emoji captions:', error));
                    }
                })
                .catch(error => console.error('Error loading captions:', error));
        }

        function startCaptionsDisplay(captionsData) {
            const video = document.getElementById('video');
            const svgCaptions = document.getElementById('svg-captions');
            let currentIndex = 0;
            let textElement = null;

            function updateCaptions() {
                const currentTime = video.currentTime;

                if (currentIndex < captionsData.length && currentTime >= captionsData[currentIndex].startTime && currentTime < captionsData[currentIndex].endTime) {
                    if (!textElement) {
                        textElement = document.createElementNS('http://www.w3.org/2000/svg', 'text');
                        textElement.setAttribute('x', '50%');
                        textElement.setAttribute('y', captionY);
                        textElement.setAttribute('dominant-baseline', 'middle');
                        textElement.setAttribute('text-anchor', 'middle');
                        svgCaptions.appendChild(textElement);
                    }
                    // Apply the 'All Caps' setting
                    textElement.textContent = (textAllCaps === 'Yes') ? captionsData[currentIndex].text.toUpperCase() : captionsData[currentIndex].text;
                } else if (currentIndex < captionsData.length && currentTime >= captionsData[currentIndex].endTime) {
                    currentIndex++;
                    if (textElement) {
                        svgCaptions.removeChild(textElement);
                        textElement = null;
                    }
                }

                requestAnimationFrame(updateCaptions);
            }

            updateCaptions();
        }

        function startEmojiDisplay(emojiCaptionsData) {
            const video = document.getElementById('video');
            const svgEmoji = document.getElementById('svg-emoji');
            let currentIndex = 0;
            let emojiElement = null;

            function updateEmojis() {
                const currentTime = video.currentTime;

                if (currentIndex < emojiCaptionsData.length && currentTime >= emojiCaptionsData[currentIndex].startTime && currentTime < emojiCaptionsData[currentIndex].endTime) {
                    if (!emojiElement) {
                        emojiElement = document.createElementNS('http://www.w3.org/2000/svg', 'text');
                        emojiElement.setAttribute('x', '50%');
                        emojiElement.setAttribute('y', emojiY);
                        emojiElement.setAttribute('dominant-baseline', 'central');
                        emojiElement.setAttribute('text-anchor', 'middle');
                        emojiElement.classList.add('emoji');
                        svgEmoji.appendChild(emojiElement);
                    }
                    emojiElement.textContent = emojiCaptionsData[currentIndex].text || '';
                } else if (currentIndex < emojiCaptionsData.length && currentTime >= emojiCaptionsData[currentIndex].endTime) {
                    currentIndex++;
                    if (emojiElement) {
                        svgEmoji.removeChild(emojiElement);
                        emojiElement = null;
                    }
                }

                requestAnimationFrame(updateEmojis);
            }

            updateEmojis();
        }
    </script>
</body>
</html>
